/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.term;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class CompoundTermTag
implements Serializable {
    private static final long serialVersionUID = -208937166475321367L;
    private static final Map<AtomTerm, List<CompoundTermTag>> atom2tag = new WeakHashMap<AtomTerm, List<CompoundTermTag>>();
    public static final CompoundTermTag comma = CompoundTermTag.get(",", 2);
    public static final CompoundTermTag curly1 = CompoundTermTag.get("{}", 1);
    public static final CompoundTermTag minus2 = CompoundTermTag.get("-", 2);
    public static final CompoundTermTag divide2 = CompoundTermTag.get("/", 2);
    public final AtomTerm functor;
    public final int arity;

    public CompoundTerm getPredicateIndicator() {
        return new CompoundTerm(divide2, this.functor, IntegerTerm.get(this.arity));
    }

    public static CompoundTermTag get(CompoundTerm predicateIndicator) {
        if (!(predicateIndicator.args[0] instanceof AtomTerm) || !(predicateIndicator.args[1] instanceof IntegerTerm)) {
            throw new IllegalArgumentException();
        }
        return CompoundTermTag.get((AtomTerm)predicateIndicator.args[0], ((IntegerTerm)predicateIndicator.args[1]).value);
    }

    public static boolean isPredicateIndicator(Term term) {
        if (!(term instanceof CompoundTerm)) {
            return false;
        }
        CompoundTerm ct = (CompoundTerm)term;
        return ct.args[0] instanceof AtomTerm && ct.args[1] instanceof IntegerTerm;
    }

    public static CompoundTermTag get(String functor, int arity) {
        return CompoundTermTag.get(AtomTerm.get(functor), arity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTermTag get(AtomTerm functor, int arity) {
        Map<AtomTerm, List<CompoundTermTag>> map = atom2tag;
        synchronized (map) {
            List<CompoundTermTag> ctgs = atom2tag.get(functor);
            if (ctgs != null) {
                CompoundTermTag tg2;
                for (CompoundTermTag tg2 : ctgs) {
                    if (tg2.arity != arity) continue;
                    return tg2;
                }
                tg2 = new CompoundTermTag(functor, arity);
                ctgs.add(tg2);
                return tg2;
            }
            CompoundTermTag tg = new CompoundTermTag(functor, arity);
            ctgs = new ArrayList<CompoundTermTag>();
            ctgs.add(tg);
            atom2tag.put(functor, ctgs);
            return tg;
        }
    }

    protected CompoundTermTag(AtomTerm f, int a) {
        this.functor = f;
        this.arity = a;
    }

    public Object readResolve() {
        return CompoundTermTag.get(this.functor, this.arity);
    }

    public String toString() {
        return String.valueOf(this.functor.value) + "/" + this.arity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.arity;
        result = 31 * result + (this.functor == null ? 0 : this.functor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundTermTag other = (CompoundTermTag)obj;
        if (this.arity != other.arity) {
            return false;
        }
        return !(this.functor == null ? other.functor != null : !this.functor.equals(other.functor));
    }
}

