/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.Version;
import gnu.prolog.database.Module;
import gnu.prolog.database.Pair;
import gnu.prolog.database.Predicate;
import gnu.prolog.database.PredicateListener;
import gnu.prolog.database.PredicateUpdatedEvent;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.database.PrologTextLoaderState;
import gnu.prolog.io.BinaryPrologStream;
import gnu.prolog.io.CharConversionTable;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.PrologStream;
import gnu.prolog.io.TextInputPrologStream;
import gnu.prolog.io.TextOutputPrologStream;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.EnvInitializer;
import gnu.prolog.vm.HasAtom;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologCodeListener;
import gnu.prolog.vm.PrologCodeUpdatedEvent;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.UndefinedPredicateCode;
import gnu.prolog.vm.interpreter.InterpretedCodeCompiler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Environment
implements PredicateListener {
    protected OperatorSet opSet = new OperatorSet();
    protected PrologTextLoaderState prologTextLoaderState;
    protected PrologCode undefinedPredicate;
    protected Map<CompoundTermTag, PrologCode> tag2code = new HashMap<CompoundTermTag, PrologCode>();
    public static final AtomTerm boundedAtom = AtomTerm.get("bounded");
    public static final AtomTerm integerRoundingFunctionAtom = AtomTerm.get("integer_rounding_function");
    public static final AtomTerm downAtom = AtomTerm.get("down");
    public static final AtomTerm towardZeroAtom = AtomTerm.get("toward_zero");
    public static final AtomTerm charConversionAtom = AtomTerm.get("char_conversion");
    public static final AtomTerm onAtom = AtomTerm.get("on");
    public static final AtomTerm offAtom = AtomTerm.get("off");
    public static final AtomTerm debugAtom = AtomTerm.get("debug");
    public static final AtomTerm unknownAtom = AtomTerm.get("unknown");
    public static final AtomTerm errorAtom = AtomTerm.get("error");
    public static final AtomTerm warningAtom = AtomTerm.get("warning");
    public static final AtomTerm doubleQuotesAtom = AtomTerm.get("double_quotes");
    public static final AtomTerm dialectAtom = AtomTerm.get("dialect");
    public static final AtomTerm versionAtom = AtomTerm.get("version");
    public static final IntegerTerm maxIntegerTerm = IntegerTerm.get(Integer.MAX_VALUE);
    public static final IntegerTerm minIntegerTerm = IntegerTerm.get(Integer.MIN_VALUE);
    public static final AtomTerm dialectTerm = AtomTerm.get("gnuprologjava");
    public static final IntegerTerm versionTerm = IntegerTerm.get(Version.intEncoded());
    public static final AtomTerm prologFlagAtom = AtomTerm.get("prolog_flag");
    public static final AtomTerm flagValueAtom = AtomTerm.get("flag_value");
    public static final AtomTerm modifyAtom = AtomTerm.get("modify");
    public static final CompoundTermTag plusTag = CompoundTermTag.get("+", 2);
    protected Map<AtomTerm, Term> atom2flag = new HashMap<AtomTerm, Term>();
    protected Set<AtomTerm> changableFlags = new HashSet<AtomTerm>();
    protected Map<CompoundTermTag, List<PrologCodeListenerRef>> tag2listeners = new HashMap<CompoundTermTag, List<PrologCodeListenerRef>>();
    protected ReferenceQueue<? super PrologCodeListener> prologCodeListenerReferenceQueue = new ReferenceQueue();
    private static InputStream defaultInputStream;
    private static OutputStream defaultOutputStream;
    protected PrologStream userInput;
    protected PrologStream userOutput;
    protected PrologStream currentInput;
    protected PrologStream currentOutput;
    protected List<PrologStream> openStreams = new ArrayList<PrologStream>();
    protected Map<AtomTerm, PrologStream> alias2stream = new HashMap<AtomTerm, PrologStream>();

    public Environment() {
        this(null, null);
    }

    public Environment(InputStream stdin, OutputStream stdout) {
        this.createTextLoader();
        this.initEnvironment();
        this.initStreams(stdin, stdout);
    }

    protected void initEnvironment() {
        CompoundTerm term = new CompoundTerm(AtomTerm.get("resource"), new Term[]{AtomTerm.get("/gnu/prolog/vm/buildins/buildins.pro")});
        this.ensureLoaded(term);
        this.createNewPrologFlag(boundedAtom, TermConstants.trueAtom, false);
        this.createNewPrologFlag(TermConstants.maxIntegerAtom, maxIntegerTerm, false);
        this.createNewPrologFlag(TermConstants.minIntegerAtom, minIntegerTerm, false);
        this.createNewPrologFlag(integerRoundingFunctionAtom, downAtom, false);
        this.createNewPrologFlag(charConversionAtom, offAtom, true);
        this.createNewPrologFlag(debugAtom, offAtom, true);
        long maxMemory = Runtime.getRuntime().maxMemory();
        IntegerTerm maxArity = maxMemory < (long)Environment.maxIntegerTerm.value ? IntegerTerm.get((int)maxMemory) : maxIntegerTerm;
        this.createNewPrologFlag(TermConstants.maxArityAtom, maxArity, false);
        this.createNewPrologFlag(unknownAtom, errorAtom, true);
        this.createNewPrologFlag(doubleQuotesAtom, DoubleQuotesValue.getDefault().getAtom(), true);
        this.createNewPrologFlag(dialectAtom, dialectTerm, false);
        this.createNewPrologFlag(versionAtom, versionTerm, false);
        EnvInitializer.runInitializers(this);
    }

    protected void createTextLoader() {
        this.prologTextLoaderState = new PrologTextLoaderState(this);
    }

    @Deprecated
    public PrologTextLoaderState getTextLoaderState() {
        return this.prologTextLoaderState;
    }

    public boolean isInitialized() {
        return this.getModule().getInitialization().size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInitialization(Interpreter interpreter) {
        List<Pair<PrologTextLoaderError, Term>> initialization;
        Module module;
        Module module2 = module = this.getModule();
        synchronized (module2) {
            initialization = module.getInitialization();
            module.clearInitialization();
        }
        for (Pair<PrologTextLoaderError, Term> loaderTerm : initialization) {
            Term term = (Term)loaderTerm.right;
            try {
                Interpreter.Goal goal = interpreter.prepareGoal(term);
                int rc = interpreter.execute(goal);
                if (rc == 0) {
                    interpreter.stop(goal);
                    continue;
                }
                if (rc == 1) continue;
                this.prologTextLoaderState.logError((PrologTextLoaderError)loaderTerm.left, "Goal Failed: " + term);
            }
            catch (PrologException ex) {
                this.prologTextLoaderState.logError((PrologTextLoaderError)loaderTerm.left, ex.getMessage());
            }
        }
    }

    public synchronized Map<AtomTerm, Term> getPrologFlags() {
        return new HashMap<AtomTerm, Term>(this.atom2flag);
    }

    public synchronized Term getPrologFlag(AtomTerm term) {
        return this.atom2flag.get(term);
    }

    protected synchronized void createNewPrologFlag(AtomTerm flag, Term newValue, boolean changable) {
        this.atom2flag.put(flag, newValue);
        if (changable) {
            this.changableFlags.add(flag);
        }
    }

    public synchronized void setPrologFlag(AtomTerm flag, Term newValue) throws PrologException {
        Term value = this.atom2flag.get(flag);
        if (value == null) {
            PrologException.domainError(prologFlagAtom, flag);
        }
        if (flag == boundedAtom) {
            if (newValue != TermConstants.trueAtom && newValue != TermConstants.falseAtom) {
                PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == TermConstants.maxIntegerAtom) {
            if (!(newValue instanceof IntegerTerm)) {
                PrologException.domainError(prologFlagAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == TermConstants.minIntegerAtom) {
            if (!(newValue instanceof IntegerTerm)) {
                PrologException.domainError(prologFlagAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == integerRoundingFunctionAtom) {
            if (newValue != downAtom && newValue != towardZeroAtom) {
                PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == charConversionAtom) {
            if (newValue != onAtom && newValue != offAtom) {
                PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == debugAtom) {
            if (newValue != onAtom && newValue != offAtom) {
                PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == TermConstants.maxArityAtom) {
            if (!(newValue instanceof IntegerTerm)) {
                PrologException.domainError(prologFlagAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (flag == unknownAtom) {
            if (newValue != errorAtom && newValue != TermConstants.failAtom && newValue != warningAtom) {
                PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
            }
        } else if (!(flag != doubleQuotesAtom || newValue instanceof AtomTerm && DoubleQuotesValue.fromAtom((AtomTerm)newValue) != null)) {
            PrologException.domainError(flagValueAtom, new CompoundTerm(plusTag, flag, newValue));
        }
        if (!this.changableFlags.contains(flag)) {
            PrologException.permissionError(modifyAtom, TermConstants.flagAtom, flag);
        }
        this.atom2flag.put(flag, newValue);
    }

    public List<PrologTextLoaderError> getLoadingErrors() {
        return this.prologTextLoaderState.getErrors();
    }

    public PrologTextLoaderState getPrologTextLoaderState() {
        return this.prologTextLoaderState;
    }

    public synchronized void ensureLoaded(Term term) {
        this.prologTextLoaderState.ensureLoaded(term);
    }

    public Interpreter createInterpreter() {
        return new Interpreter(this);
    }

    public Module getModule() {
        return this.prologTextLoaderState.getModule();
    }

    public synchronized PrologCode loadPrologCode(CompoundTermTag tag) throws PrologException {
        Predicate p = this.prologTextLoaderState.getModule().getDefinedPredicate(tag);
        if (p == null) {
            return this.getUndefinedPredicateCode(tag);
        }
        switch (p.getType()) {
            case CONTROL: 
            case BUILD_IN: 
            case EXTERNAL: {
                try {
                    Class<?> cls = Class.forName(p.getJavaClassName());
                    PrologCode code = (PrologCode)cls.newInstance();
                    code.install(this);
                    return code;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return this.getUndefinedPredicateCode(tag);
                }
            }
            case USER_DEFINED: {
                PrologCode code = InterpretedCodeCompiler.compile(p.getClauses());
                code.install(this);
                return code;
            }
        }
        return this.getUndefinedPredicateCode(tag);
    }

    public PrologCode getUndefinedPredicateCode(CompoundTermTag tag) {
        return new UndefinedPredicateCode(tag);
    }

    public synchronized PrologCode getPrologCode(CompoundTermTag tag) throws PrologException {
        PrologCode code = this.tag2code.get(tag);
        if (code == null) {
            code = this.loadPrologCode(tag);
            this.tag2code.put(tag, code);
        }
        return code;
    }

    protected void pollPrologCodeListeners() {
        PrologCodeListenerRef ref;
        while (null != (ref = (PrologCodeListenerRef)this.prologCodeListenerReferenceQueue.poll())) {
            List<PrologCodeListenerRef> list = this.tag2listeners.get(ref.tag);
            list.remove(ref);
        }
    }

    public synchronized void addPrologCodeListener(CompoundTermTag tag, PrologCodeListener listener) {
        this.pollPrologCodeListeners();
        List<PrologCodeListenerRef> list = this.tag2listeners.get(tag);
        if (list == null) {
            list = new ArrayList<PrologCodeListenerRef>();
            this.tag2listeners.put(tag, list);
        }
        list.add(new PrologCodeListenerRef(this.prologCodeListenerReferenceQueue, listener, tag));
    }

    public synchronized void removePrologCodeListener(CompoundTermTag tag, PrologCodeListener listener) {
        this.pollPrologCodeListeners();
        List<PrologCodeListenerRef> list = this.tag2listeners.get(tag);
        if (list != null) {
            ListIterator<PrologCodeListenerRef> i = list.listIterator();
            while (i.hasNext()) {
                PrologCodeListenerRef ref = i.next();
                PrologCodeListener lst = (PrologCodeListener)ref.get();
                if (lst == null) {
                    i.remove();
                    continue;
                }
                if (lst != listener) continue;
                i.remove();
                return;
            }
        }
    }

    @Override
    public synchronized void predicateUpdated(PredicateUpdatedEvent evt) {
        PrologCode code = this.tag2code.remove(evt.getTag());
        this.pollPrologCodeListeners();
        if (code == null) {
            return;
        }
        CompoundTermTag tag = evt.getTag();
        List<PrologCodeListenerRef> list = this.tag2listeners.get(tag);
        if (list != null) {
            PrologCodeUpdatedEvent uevt = new PrologCodeUpdatedEvent(this, tag);
            ListIterator<PrologCodeListenerRef> i = list.listIterator();
            while (i.hasNext()) {
                PrologCodeListenerRef ref = i.next();
                PrologCodeListener lst = (PrologCodeListener)ref.get();
                if (lst == null) {
                    i.remove();
                    continue;
                }
                lst.prologCodeUpdated(uevt);
                return;
            }
        }
    }

    public static InputStream getDefaultInputStream() {
        return defaultInputStream == null ? System.in : defaultInputStream;
    }

    public static void setDefaultInputStream(InputStream defaultInputStream) {
        Environment.defaultInputStream = defaultInputStream;
    }

    public static OutputStream getDefaultOutputStream() {
        return defaultOutputStream == null ? System.out : defaultOutputStream;
    }

    public static void setDefaultOutputStream(OutputStream defaultOutputStream) {
        Environment.defaultOutputStream = defaultOutputStream;
    }

    public OperatorSet getOperatorSet() {
        return this.opSet;
    }

    protected void initStreams(InputStream stdin, OutputStream stdout) {
        try {
            PrologStream.OpenOptions inops = new PrologStream.OpenOptions(PrologStream.userInputAtom, PrologStream.readAtom, this);
            PrologStream.OpenOptions outops = new PrologStream.OpenOptions(PrologStream.userOutputAtom, PrologStream.appendAtom, this);
            inops.aliases.add(PrologStream.userInputAtom);
            inops.eofAction = PrologStream.resetAtom;
            inops.reposition = TermConstants.falseAtom;
            inops.type = PrologStream.textAtom;
            outops.aliases.add(PrologStream.userOutputAtom);
            outops.eofAction = PrologStream.resetAtom;
            outops.reposition = TermConstants.falseAtom;
            outops.type = PrologStream.textAtom;
            this.userInput = new TextInputPrologStream(inops, new InputStreamReader(stdin == null ? Environment.getDefaultInputStream() : stdin));
            this.userOutput = new TextOutputPrologStream(outops, new OutputStreamWriter(stdout == null ? Environment.getDefaultOutputStream() : stdout));
            this.setCurrentInput(this.getUserInput());
            this.setCurrentOutput(this.getUserOutput());
            this.alias2stream.put(PrologStream.userOutputAtom, this.userOutput);
            this.alias2stream.put(PrologStream.userInputAtom, this.userInput);
            this.openStreams.add(this.userInput);
            this.openStreams.add(this.userOutput);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("unable to intialize standard streams");
        }
    }

    public synchronized PrologStream getUserInput() throws PrologException {
        return this.userInput;
    }

    public synchronized PrologStream getUserOutput() throws PrologException {
        return this.userOutput;
    }

    public synchronized PrologStream getCurrentInput() throws PrologException {
        return this.currentInput;
    }

    public synchronized PrologStream getCurrentOutput() throws PrologException {
        return this.currentOutput;
    }

    public synchronized void setCurrentInput(PrologStream stream) throws PrologException {
        this.currentInput = stream;
    }

    public synchronized void setCurrentOutput(PrologStream stream) throws PrologException {
        this.currentOutput = stream;
    }

    public synchronized Map<PrologStream, List<Term>> getStreamProperties() throws PrologException {
        HashMap<PrologStream, List<Term>> map = new HashMap<PrologStream, List<Term>>();
        for (PrologStream stream : this.openStreams) {
            ArrayList<Term> list = new ArrayList<Term>();
            stream.getProperties(list);
            map.put(stream, list);
        }
        return map;
    }

    public synchronized PrologStream resolveStream(Term stream_or_alias) throws PrologException {
        if ((stream_or_alias = stream_or_alias.dereference()) instanceof VariableTerm) {
            PrologException.instantiationError();
        } else {
            if (stream_or_alias instanceof AtomTerm) {
                PrologStream stream = this.alias2stream.get(stream_or_alias);
                if (stream == null) {
                    PrologException.existenceError(PrologStream.streamAtom, stream_or_alias);
                } else {
                    stream.checkExists();
                }
                return stream;
            }
            if (stream_or_alias instanceof JavaObjectTerm) {
                PrologStream stream;
                JavaObjectTerm jt = (JavaObjectTerm)stream_or_alias;
                if (!(jt.value instanceof PrologStream)) {
                    PrologException.domainError(PrologStream.streamOrAliasAtom, stream_or_alias);
                }
                if ((stream = (PrologStream)jt.value).isClosed()) {
                    PrologException.existenceError(PrologStream.streamAtom, stream_or_alias);
                }
                return stream;
            }
            PrologException.domainError(PrologStream.streamOrAliasAtom, stream_or_alias);
        }
        return null;
    }

    public synchronized Term open(AtomTerm source_sink, AtomTerm mode, PrologStream.OpenOptions options) throws PrologException {
        PrologStream stream;
        block15: {
            for (AtomTerm a : options.aliases) {
                if (this.alias2stream.get(a) == null) continue;
                PrologException.permissionError(PrologStream.openAtom, PrologStream.sourceSinkAtom, new CompoundTerm(PrologStream.aliasTag, a));
            }
            stream = null;
            if (options.type == PrologStream.binaryAtom) {
                stream = new BinaryPrologStream(source_sink, mode, options);
            } else if (options.type == PrologStream.textAtom) {
                boolean randAccess;
                boolean bl = randAccess = options.reposition == TermConstants.trueAtom;
                if (options.mode == PrologStream.readAtom) {
                    if (!new File(source_sink.value).exists()) {
                        PrologException.existenceError(PrologStream.sourceSinkAtom, source_sink);
                    }
                    try {
                        if (randAccess) {
                            RandomAccessFile raf = new RandomAccessFile(source_sink.value, "r");
                            stream = new TextInputPrologStream(options, raf);
                            break block15;
                        }
                        FileReader rd = new FileReader(source_sink.value);
                        stream = new TextInputPrologStream(options, rd);
                    }
                    catch (IOException ex) {
                        PrologException.permissionError(PrologStream.openAtom, PrologStream.sourceSinkAtom, source_sink);
                    }
                } else {
                    boolean append = options.mode == PrologStream.appendAtom;
                    try {
                        if (randAccess) {
                            RandomAccessFile raf = new RandomAccessFile(source_sink.value, "rw");
                            stream = new TextOutputPrologStream(options, raf);
                            break block15;
                        }
                        FileWriter wr = new FileWriter(source_sink.value, append);
                        stream = new TextOutputPrologStream(options, wr);
                    }
                    catch (IOException ex) {
                        PrologException.permissionError(PrologStream.openAtom, PrologStream.sourceSinkAtom, source_sink);
                    }
                }
            } else {
                PrologException.domainError(AtomTerm.get("invalid_stream_type"), options.type);
            }
        }
        for (AtomTerm a : options.aliases) {
            this.alias2stream.put(a, stream);
        }
        this.openStreams.add(stream);
        return stream.getStreamTerm();
    }

    public synchronized boolean close(PrologStream stream) throws PrologException {
        if (stream == this.userInput) {
            return false;
        }
        if (stream == this.userOutput) {
            this.userOutput.flushOutput(null);
            return false;
        }
        for (AtomTerm alias : stream.getAliases()) {
            this.alias2stream.remove(alias);
        }
        this.openStreams.remove(stream);
        if (this.currentInput == stream) {
            this.currentInput = this.userInput;
        }
        if (this.currentOutput == stream) {
            this.currentOutput = this.userOutput;
        }
        return true;
    }

    public void closeStreams() {
        for (PrologStream stream : new ArrayList<PrologStream>(this.openStreams)) {
            try {
                this.close(stream);
            }
            catch (PrologException e) {
                e.printStackTrace();
            }
        }
    }

    public CharConversionTable getConversionTable() {
        return this.prologTextLoaderState.getConversionTable();
    }

    private static class PrologCodeListenerRef
    extends WeakReference<PrologCodeListener> {
        CompoundTermTag tag;

        PrologCodeListenerRef(ReferenceQueue<? super PrologCodeListener> queue, PrologCodeListener listener, CompoundTermTag tag) {
            super(listener, queue);
            this.tag = tag;
        }
    }

    public static enum DoubleQuotesValue implements HasAtom
    {
        DQ_CODES{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.codesAtom;
            }
        }
        ,
        DQ_CHARS{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.charsAtom;
            }
        }
        ,
        DQ_ATOM{

            @Override
            public AtomTerm getAtom() {
                return TermConstants.atomAtom;
            }
        };


        @Override
        public abstract AtomTerm getAtom();

        public static DoubleQuotesValue fromAtom(AtomTerm value) {
            if (TermConstants.codesAtom == value) {
                return DQ_CODES;
            }
            if (TermConstants.charsAtom == value) {
                return DQ_CHARS;
            }
            if (TermConstants.atomAtom == value) {
                return DQ_ATOM;
            }
            return null;
        }

        public static DoubleQuotesValue getDefault() {
            return DQ_CODES;
        }
    }
}

