#!BPY
"""
Name: 'Hyperboloid'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Bartius Crouch"]
__version__ = '1.00'
__url__ = ["Script Index, http://wiki.blender.org/index.php/Scripts/Manual/Add/Add_Mesh_Hyperboloid"]
__email__=["bartius.crouch{at}gmail.com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# --------------------------------------------------------------------------
# Copyright (C) 2008 Bartius Crouch
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

import BPyAddMesh
import Blender
from math import sqrt, pi, sin, cos

def add_hyperboloid(CONTINUITY, RESOLUTION, RINGS):
	v = []
	f = []
	
	#Creating the vertices
	z_step = 100.0/(RINGS-1)
	for k in range(-1,2,2):
		for i in range(0,RINGS):
			i*=k
			z = i*z_step
			radius = sqrt(z**2-CONTINUITY)
			for j in range(0,RESOLUTION):
				angle = float(j)/RESOLUTION*2*pi
				x = cos(angle)*radius
				y = sin(angle)*radius
				v.append([x/100,y/100,z/100])
	v = v[RESOLUTION:len(v)]	
	
	#Creating the faces of the lower half
	for j in range(0,RINGS-1):
		for i in range(0,RESOLUTION):
			if(i==RESOLUTION-1):
				c = RESOLUTION
			else:
				c = 0
			i+=j*RESOLUTION
			f.append([i,i+RESOLUTION,i+RESOLUTION+1-c,i+1-c])
	f = f[0:-RESOLUTION]
	#Creating the faces of the lower half connecting with the upper half
	for i in range(0,RESOLUTION):
		if(i==RESOLUTION-1):
			c = RESOLUTION
		else:
			c = 0
		i+=j*RESOLUTION
		f.append([i+RESOLUTION*(-RINGS+2),i+1-c+RESOLUTION*(-RINGS+2),i+RESOLUTION+1-c,i+RESOLUTION])
	#Creating the faces of the upper half
	for j in range(RINGS-1,2*RINGS-2):
		for i in range(0,RESOLUTION):
			if(i==RESOLUTION-1):
				c = RESOLUTION
			else:
				c = 0
			i+=j*RESOLUTION
			f.append([i,i+1-c,i+RESOLUTION+1-c,i+RESOLUTION])
	
	return v, f

def main():
	CONTINUITY = Blender.Draw.Create(3.00)
	RESOLUTION = Blender.Draw.Create(32)
	RINGS = Blender.Draw.Create(5)

	if not Blender.Draw.PupBlock('Add Hyperboloid', [\
	('Centre:', CONTINUITY,  0.00, 10.00, 'Influences the radius of the center'),\
	('Resolution:', RESOLUTION, 3, 500, 'Number of vertices per ring'),\
	('Rings:', RINGS, 3, 500, 'Number of rings in each half of the hyperboloid'),\
	]):
		return
	
	v, f = add_hyperboloid(-1000*CONTINUITY.val, RESOLUTION.val, RINGS.val)
	
	BPyAddMesh.add_mesh_simple('Hyperboloid', v, [], f)

main()