/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.msgextract;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.BadNodePlacementError;
import com.google.gxp.compiler.alerts.common.InvalidMessageError;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderNode;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.i18ncheck.I18nCheckedTree;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import com.google.gxp.compiler.msgextract.TooManyDynamicPlaceholdersError;
import com.google.transconsole.common.messages.InvalidMessageException;
import com.google.transconsole.common.messages.Message;
import com.google.transconsole.common.messages.MessageBuilder;
import java.util.ArrayList;
import java.util.List;

public class MessageExtractor
implements Function<I18nCheckedTree, MessageExtractedTree> {
    @Override
    public MessageExtractedTree apply(I18nCheckedTree tree) {
        ArrayList<ExtractedMessage> messages = Lists.newArrayList();
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(tree.getAlerts());
        Root root = tree.getRoot().acceptVisitor(new OutsideMessageVisitor(alertSetBuilder, messages));
        return new MessageExtractedTree(tree.getSourcePosition(), alertSetBuilder.buildAndClear(), root, messages);
    }

    private static class InsideMessageVisitor
    extends DefaultingExpressionVisitor<Void> {
        private final AlertSink alertSink;
        private final OutsideMessageVisitor outsideMessageVisitor;
        private final UnextractedMessage msg;
        private final MessageBuilder tcMessageBuilder = new MessageBuilder();
        private final List<Expression> parameters = Lists.newArrayList();
        private boolean invalid = false;
        private static final int MAX_DYNAMIC_PLACEHOLDER_COUNT = 9;

        InsideMessageVisitor(AlertSink alertSink, OutsideMessageVisitor outsideMessageVisitor, UnextractedMessage msg) {
            SourcePosition source;
            this.alertSink = Preconditions.checkNotNull(alertSink);
            this.outsideMessageVisitor = Preconditions.checkNotNull(outsideMessageVisitor);
            this.msg = Preconditions.checkNotNull(msg);
            this.tcMessageBuilder.setContentType(msg.getSchema().getCanonicalContentType());
            if (null != msg.getMeaning()) {
                this.tcMessageBuilder.setMeaning(msg.getMeaning());
            }
            if (msg.isHidden()) {
                this.tcMessageBuilder.setHidden(true);
            }
            if (null != msg.getComment()) {
                this.tcMessageBuilder.setDescription(msg.getComment());
            }
            if ((source = msg.getSourcePosition()) != null) {
                this.tcMessageBuilder.addSource(source.getSource().toRelativeFilename() + ": L" + source.getLine() + ", C" + (source.getColumn() - 1));
            }
        }

        Expression getResult() {
            if (!this.invalid) {
                try {
                    Message message = this.tcMessageBuilder.createMessage();
                    ExtractedMessage emsg = new ExtractedMessage(this.msg, this.msg.getSchema(), message, this.parameters);
                    this.outsideMessageVisitor.addMessages(emsg);
                    return emsg;
                }
                catch (InvalidMessageException imx) {
                    this.recordInvalidMessageException(this.msg, imx);
                }
            }
            if (!this.invalid) {
                throw new AssertionError((Object)"Attempting to create stand-in when message is valid!");
            }
            return new StringConstant(this.msg, this.msg.getSchema(), "");
        }

        private void recordInvalidMessageException(Node node, InvalidMessageException imx) {
            this.alertSink.add(new InvalidMessageError(node.getSourcePosition(), imx));
            this.invalid = true;
        }

        @Override
        public Void visitStringConstant(StringConstant value) {
            this.tcMessageBuilder.appendText(value.evaluate());
            return null;
        }

        @Override
        public Void visitConcatenation(Concatenation value) {
            for (Expression subExpression : value.getValues()) {
                subExpression.acceptVisitor(this);
            }
            return null;
        }

        @Override
        public Void visitConvertibleToContent(ConvertibleToContent value) {
            value.getSubexpression().acceptVisitor(this);
            return null;
        }

        @Override
        public Void visitExampleExpression(ExampleExpression value) {
            return value.getSubexpression().acceptVisitor(this);
        }

        @Override
        protected Void defaultVisitExpression(Expression node) {
            this.alertSink.add(new BadNodePlacementError(node, this.msg));
            return null;
        }

        @Override
        public Void visitPlaceholderNode(PlaceholderNode ph) {
            StringBuilder sb = new StringBuilder();
            for (Expression subExpression : ph.getContent().separate()) {
                int index;
                if ((subExpression = subExpression.acceptVisitor(this.outsideMessageVisitor)).hasStaticString()) {
                    String s = Preconditions.checkNotNull(subExpression.getStaticString(this.alertSink, null));
                    sb.append(s.replace("%", "%%"));
                    continue;
                }
                for (index = 0; index < this.parameters.size() && !this.parameters.get(index).alwaysEquals(subExpression); ++index) {
                }
                int id = index + 1;
                if (id > 9) {
                    this.alertSink.add(new TooManyDynamicPlaceholdersError(subExpression));
                    continue;
                }
                if (index == this.parameters.size()) {
                    this.parameters.add(subExpression);
                }
                sb.append("%");
                sb.append(String.valueOf(id));
            }
            try {
                this.tcMessageBuilder.appendPlaceholder(sb.toString(), ph.getName().toUpperCase(), ph.getExample());
            }
            catch (InvalidMessageException imx) {
                this.recordInvalidMessageException(ph, imx);
            }
            return null;
        }

        @Override
        public Void visitOutputElement(OutputElement value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Void visitCollapseExpression(CollapseExpression value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Void visitExtractedMessage(ExtractedMessage value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Void visitPlaceholderStart(PlaceholderStart value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Void visitPlaceholderEnd(PlaceholderEnd value) {
            throw new UnexpectedNodeException(value);
        }
    }

    private static class InsideNoMessageVisitor
    extends ExhaustiveExpressionVisitor {
        private final AlertSink alertSink;
        private final NoMessage rootNoMsg;
        private final OutsideMessageVisitor outsideMessageVisitor;

        InsideNoMessageVisitor(AlertSink alertSink, NoMessage rootNoMsg, OutsideMessageVisitor outsideMessageVisitor) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
            this.rootNoMsg = Preconditions.checkNotNull(rootNoMsg);
            this.outsideMessageVisitor = Preconditions.checkNotNull(outsideMessageVisitor);
        }

        @Override
        public Expression visitUnextractedMessage(UnextractedMessage msg) {
            this.alertSink.add(new BadNodePlacementError(msg, this.rootNoMsg));
            return msg.acceptVisitor(this.outsideMessageVisitor);
        }

        @Override
        public Expression visitNoMessage(NoMessage noMsg) {
            this.alertSink.add(new BadNodePlacementError(noMsg, this.rootNoMsg));
            return noMsg.getSubexpression().acceptVisitor(this);
        }

        @Override
        public Expression visitPlaceholderNode(PlaceholderNode ph) {
            this.alertSink.add(new BadNodePlacementError(ph, this.rootNoMsg));
            return ph.getContent().acceptVisitor(this);
        }

        @Override
        public Expression visitPlaceholderStart(PlaceholderStart value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Expression visitPlaceholderEnd(PlaceholderEnd value) {
            throw new UnexpectedNodeException(value);
        }
    }

    private static class OutsideMessageVisitor
    extends ExhaustiveExpressionVisitor {
        private final AlertSink alertSink;
        private final List<ExtractedMessage> messages;

        OutsideMessageVisitor(AlertSink alertSink, List<ExtractedMessage> messages) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
            this.messages = Preconditions.checkNotNull(messages);
        }

        public void addMessages(ExtractedMessage message) {
            this.messages.add(message);
        }

        @Override
        public Expression visitNoMessage(NoMessage noMsg) {
            InsideNoMessageVisitor insideNoMsgVisitor = new InsideNoMessageVisitor(this.alertSink, noMsg, this);
            return noMsg.getSubexpression().acceptVisitor(insideNoMsgVisitor);
        }

        @Override
        public Expression visitUnextractedMessage(UnextractedMessage msg) {
            InsideMessageVisitor subVisitor = new InsideMessageVisitor(this.alertSink, this, msg);
            msg.getContent().acceptVisitor(subVisitor);
            return subVisitor.getResult();
        }

        @Override
        public Expression visitPlaceholderNode(PlaceholderNode ph) {
            this.alertSink.add(new BadNodePlacementError(ph, null));
            return ph.getContent().acceptVisitor(this);
        }

        @Override
        public Expression visitPlaceholderStart(PlaceholderStart value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Expression visitPlaceholderEnd(PlaceholderEnd value) {
            throw new UnexpectedNodeException(value);
        }
    }
}

