/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.bundle.tracker.internal.BundledScriptFinder;
import org.apache.sling.scripting.bundle.tracker.internal.BundledScriptServlet;
import org.apache.sling.scripting.bundle.tracker.internal.ScriptContextProvider;
import org.apache.sling.scripting.bundle.tracker.internal.TypeProvider;
import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
@Capability(namespace="osgi.extender", name="sling.scripting", version="1.0.0")
public class BundledScriptTracker
implements BundleTrackerCustomizer<List<ServiceRegistration<Servlet>>> {
    static final String NS_SLING_SCRIPTING_EXTENDER = "sling.scripting";
    static final String NS_SLING_RESOURCE_TYPE = "sling.resourceType";
    private static final Logger LOGGER = LoggerFactory.getLogger(BundledScriptTracker.class);
    private static final String AT_SLING_SELECTORS = "sling.resourceType.selectors";
    private static final String AT_SLING_EXTENSIONS = "sling.resourceType.extensions";
    private static final String REGISTERING_BUNDLE = "org.apache.sling.scripting.bundle.tracker.internal.BundledScriptTracker.registering_bundle";
    static final String AT_VERSION = "version";
    private static final String AT_EXTENDS = "extends";
    @Reference
    private BundledScriptFinder bundledScriptFinder;
    @Reference
    private ScriptContextProvider scriptContextProvider;
    private volatile BundleContext m_context;
    private volatile BundleTracker<List<ServiceRegistration<Servlet>>> m_tracker;
    private volatile Map<String, ServiceRegistration<Servlet>> m_dispatchers = new HashMap<String, ServiceRegistration<Servlet>>();

    @Activate
    protected void activate(BundleContext context) {
        this.m_context = context;
        this.m_tracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
        this.m_tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.m_tracker.close();
    }

    public List<ServiceRegistration<Servlet>> addingBundle(Bundle bundle, BundleEvent event) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring.getRequiredWires("osgi.extender").stream().map(BundleWire::getProvider).map(BundleReference::getBundle).anyMatch(this.m_context.getBundle()::equals)) {
            LOGGER.debug("Inspecting bundle {} for {} capability.", (Object)bundle.getSymbolicName(), (Object)NS_SLING_RESOURCE_TYPE);
            List capabilities = bundleWiring.getCapabilities(NS_SLING_RESOURCE_TYPE);
            if (!capabilities.isEmpty()) {
                boolean precompiled = Boolean.parseBoolean((String)bundle.getHeaders().get("Sling-ResourceType-Precompiled"));
                List<ServiceRegistration<Servlet>> serviceRegistrations = capabilities.stream().flatMap(cap -> {
                    HashSet<String> methods;
                    String resourceType;
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    properties.put("sling.core.servletName", BundledScriptServlet.class.getName());
                    properties.put("service.description", cap.toString());
                    Map attributes = cap.getAttributes();
                    String resourceTypeString = resourceType = (String)attributes.get(NS_SLING_RESOURCE_TYPE);
                    Version version = (Version)attributes.get(AT_VERSION);
                    if (version != null) {
                        resourceTypeString = resourceTypeString + "/" + version;
                    }
                    properties.put("sling.servlet.resourceTypes", resourceTypeString);
                    Object selectors = attributes.get(AT_SLING_SELECTORS);
                    HashSet<String> extensions = new HashSet<String>(Arrays.asList(PropertiesUtil.toStringArray(attributes.get(AT_SLING_EXTENSIONS), (String[])new String[0])));
                    extensions.add("html");
                    properties.put("sling.servlet.extensions", extensions);
                    if (selectors != null) {
                        properties.put("sling.servlet.selectors", selectors);
                    }
                    if (!(methods = new HashSet<String>(Arrays.asList(PropertiesUtil.toStringArray(attributes.get("sling.servlet.methods"), (String[])new String[0])))).isEmpty()) {
                        properties.put("sling.servlet.methods", String.join((CharSequence)",", methods));
                    }
                    String extendsRT = (String)attributes.get(AT_EXTENDS);
                    Optional<Object> optionalWire = Optional.empty();
                    if (StringUtils.isNotEmpty((CharSequence)extendsRT)) {
                        LOGGER.debug("Bundle {} extends resource type {} through {}.", new Object[]{bundle.getSymbolicName(), extendsRT, resourceTypeString});
                        optionalWire = bundleWiring.getRequiredWires(NS_SLING_RESOURCE_TYPE).stream().filter(bundleWire -> extendsRT.equals(bundleWire.getCapability().getAttributes().get(NS_SLING_RESOURCE_TYPE)) && !bundleWire.getCapability().getAttributes().containsKey(AT_SLING_SELECTORS)).findFirst();
                    }
                    ArrayList<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
                    LinkedHashSet<TypeProvider> wiredProviders = new LinkedHashSet<TypeProvider>();
                    wiredProviders.add(new TypeProvider(resourceType, bundle));
                    wiredProviders.add(new TypeProvider(resourceTypeString, bundle));
                    if (optionalWire.isPresent()) {
                        BundleWire extendsWire = (BundleWire)optionalWire.get();
                        Bundle providerBundle = extendsWire.getProvider().getBundle();
                        Map wireCapabilityAttributes = extendsWire.getCapability().getAttributes();
                        String wireResourceType = (String)wireCapabilityAttributes.get(NS_SLING_RESOURCE_TYPE);
                        Version wireResourceTypeVersion = (Version)wireCapabilityAttributes.get(AT_VERSION);
                        String wireResourceTypeString = wireResourceType + (wireResourceTypeVersion != null ? "/" + wireResourceTypeVersion.toString() : "");
                        wiredProviders.add(new TypeProvider(wireResourceType, providerBundle));
                        wiredProviders.add(new TypeProvider(wireResourceTypeString, providerBundle));
                        properties.put("sling.servlet.resourceSuperType", wireResourceTypeString);
                    }
                    this.populateWiredProviders(wiredProviders);
                    regs.add(bundle.getBundleContext().registerService(Servlet.class, (Object)new BundledScriptServlet(this.bundledScriptFinder, this.scriptContextProvider, wiredProviders, precompiled), properties));
                    return regs.stream();
                }).collect(Collectors.toList());
                this.refreshDispatcher(serviceRegistrations);
                return serviceRegistrations;
            }
            return null;
        }
        return null;
    }

    private void populateWiredProviders(LinkedHashSet<TypeProvider> initialProviders) {
        HashSet<String> initialResourceTypes = new HashSet<String>(initialProviders.size());
        HashSet<Bundle> bundles = new HashSet<Bundle>(initialProviders.size());
        for (TypeProvider provider : initialProviders) {
            initialResourceTypes.add(provider.getType());
            bundles.add(provider.getBundle());
        }
        for (Bundle bundle : bundles) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            bundleWiring.getRequiredWires(NS_SLING_RESOURCE_TYPE).forEach(bundleWire -> {
                String resourceType = (String)bundleWire.getCapability().getAttributes().get(NS_SLING_RESOURCE_TYPE);
                Version version = (Version)bundleWire.getCapability().getAttributes().get(AT_VERSION);
                if (!initialResourceTypes.contains(resourceType)) {
                    initialProviders.add(new TypeProvider(resourceType + (version == null ? "" : "/" + version.toString()), bundleWire.getProvider().getBundle()));
                }
            });
        }
    }

    private void refreshDispatcher(List<ServiceRegistration<Servlet>> regs) {
        HashMap<String, ServiceRegistration<Servlet>> dispatchers = new HashMap<String, ServiceRegistration<Servlet>>();
        Stream.concat(this.m_tracker.getTracked().values().stream(), Stream.of(regs)).flatMap(Collection::stream).map(this::toProperties).collect(Collectors.groupingBy(this::getResourceType)).forEach((rt, propList) -> {
            ServiceRegistration reg;
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("sling.core.servletName", DispatcherServlet.class.getName());
            properties.put("sling.servlet.resourceTypes", rt);
            Set<String> methods = propList.stream().map(props -> props.getOrDefault("sling.servlet.methods", new String[]{"GET", "HEAD"})).map(PropertiesUtil::toStringArray).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toSet());
            Set<String> extensions = propList.stream().map(props -> props.getOrDefault("sling.servlet.extensions", new String[]{"html"})).map(PropertiesUtil::toStringArray).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toSet());
            properties.put("sling.servlet.extensions", extensions.toArray(new String[0]));
            if (!methods.equals(new HashSet<String>(Arrays.asList("GET", "HEAD")))) {
                properties.put("sling.servlet.methods", methods.toArray(new String[0]));
            }
            if ((reg = this.m_dispatchers.remove(rt)) == null) {
                Optional<BundleContext> registeringBundle = propList.stream().map(props -> {
                    Bundle bundle = (Bundle)props.get(REGISTERING_BUNDLE);
                    if (bundle != null) {
                        return bundle.getBundleContext();
                    }
                    return null;
                }).findFirst();
                properties.put("service.description", "sling.servlet.resourceTypes=" + rt + "; " + "sling.servlet.extensions" + "=" + extensions + "; " + "sling.servlet.methods" + "=" + methods);
                reg = registeringBundle.orElse(this.m_context).registerService(Servlet.class, (Object)new DispatcherServlet((String)rt), properties);
            } else if (!new HashSet<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)reg.getReference().getProperty("sling.servlet.methods"), (String[])new String[0]))).equals(methods)) {
                reg.setProperties(properties);
            }
            dispatchers.put((String)rt, (ServiceRegistration<Servlet>)reg);
        });
        this.m_dispatchers.values().forEach(ServiceRegistration::unregister);
        this.m_dispatchers = dispatchers;
    }

    private Hashtable<String, Object> toProperties(ServiceRegistration<?> reg) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ServiceReference ref = reg.getReference();
        this.set("sling.servlet.resourceTypes", ref, result);
        this.set("sling.servlet.extensions", ref, result);
        this.set("sling.servlet.selectors", ref, result);
        this.set("sling.servlet.methods", ref, result);
        result.put(REGISTERING_BUNDLE, reg.getReference().getBundle());
        return result;
    }

    private String getResourceType(Hashtable<String, Object> props) {
        String[] values = PropertiesUtil.toStringArray((Object)props.get("sling.servlet.resourceTypes"));
        int idx = values[0].indexOf("/");
        if (idx != -1) {
            return values[0].substring(0, idx);
        }
        return values[0];
    }

    private String getResourceTypeVersion(ServiceReference<?> ref) {
        String[] values = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"));
        int idx = values[0].indexOf("/");
        if (idx != -1) {
            return values[0].substring(idx + 1);
        }
        return null;
    }

    private void set(String key, ServiceReference<?> ref, Hashtable<String, Object> props) {
        Object value = ref.getProperty(key);
        if (value != null) {
            props.put(key, value);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<Servlet>> regs) {
        LOGGER.warn(String.format("Unexpected modified event: %s for bundle %s", event.toString(), bundle.toString()));
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<Servlet>> regs) {
        LOGGER.debug("Bundle {} removed", (Object)bundle.getSymbolicName());
        regs.forEach(ServiceRegistration::unregister);
        this.refreshDispatcher(Collections.EMPTY_LIST);
    }

    private class DispatcherServlet
    extends GenericServlet {
        private final String m_rt;

        DispatcherServlet(String rt) {
            this.m_rt = rt;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)req;
            Optional<ServiceRegistration> target = BundledScriptTracker.this.m_tracker.getTracked().values().stream().flatMap(Collection::stream).filter(((Predicate<ServiceRegistration>)reg -> reg.getReference().getBundle().equals(BundledScriptTracker.this.m_context.getBundle())).negate()).filter(reg -> BundledScriptTracker.this.getResourceTypeVersion(reg.getReference()) != null).filter(reg -> {
                Hashtable props = BundledScriptTracker.this.toProperties(reg);
                return BundledScriptTracker.this.getResourceType(props).equals(this.m_rt) && Arrays.asList(PropertiesUtil.toStringArray(props.get("sling.servlet.methods"), (String[])new String[]{"GET", "HEAD"})).contains(slingRequest.getMethod()) && Arrays.asList(PropertiesUtil.toStringArray(props.get("sling.servlet.extensions"), (String[])new String[]{"html"})).contains(slingRequest.getRequestPathInfo().getExtension() == null ? "html" : slingRequest.getRequestPathInfo().getExtension());
            }).sorted((left, right) -> {
                boolean la = Arrays.asList(PropertiesUtil.toStringArray(BundledScriptTracker.this.toProperties(left).get("sling.servlet.selectors"), (String[])new String[0])).containsAll(Arrays.asList(slingRequest.getRequestPathInfo().getSelectors()));
                boolean ra = Arrays.asList(PropertiesUtil.toStringArray(BundledScriptTracker.this.toProperties(right).get("sling.servlet.selectors"), (String[])new String[0])).containsAll(Arrays.asList(slingRequest.getRequestPathInfo().getSelectors()));
                if (la && ra || !la && !ra) {
                    return new Version(BundledScriptTracker.this.getResourceTypeVersion(right.getReference())).compareTo(new Version(BundledScriptTracker.this.getResourceTypeVersion(left.getReference())));
                }
                if (la) {
                    return -1;
                }
                return 1;
            }).findFirst();
            if (target.isPresent()) {
                String rt = (String)target.get().getReference().getProperty("sling.servlet.resourceTypes");
                RequestDispatcherOptions options = new RequestDispatcherOptions();
                options.setForceResourceType(rt);
                RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(slingRequest.getResource(), options);
                if (dispatcher != null) {
                    String contentType;
                    if (slingRequest.getAttribute("javax.servlet.include.servlet_path") == null && (contentType = slingRequest.getResponseContentType()) != null) {
                        res.setContentType(contentType);
                        if (contentType.startsWith("text/")) {
                            res.setCharacterEncoding("UTF-8");
                        }
                    }
                    dispatcher.include(req, res);
                } else {
                    ((SlingHttpServletResponse)res).sendError(404);
                }
            } else {
                ((SlingHttpServletResponse)res).sendError(404);
            }
        }
    }
}

