/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.transport.serial;

import java.net.SocketAddress;
import java.util.Objects;
import java.util.Optional;

public class SerialSocketAddress extends SocketAddress {

    private final String identifier;

    private final SerialChannelHandler handler;

    public SerialSocketAddress(String identifier) {
        this.identifier = identifier;
        this.handler = null;
    }

    /**
     * @param identifier of the port
     * @param handler    for custom behavior.  E.g. testing
     */
    public SerialSocketAddress(final String identifier, final SerialChannelHandler handler) {
        this.identifier = identifier;
        this.handler = handler;
    }

    public Optional<SerialChannelHandler> getHandler() {
        return Optional.ofNullable(handler);
    }

    public String getIdentifier() {
        return identifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SerialSocketAddress that = (SerialSocketAddress) o;
        return Objects.equals(identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(identifier);
    }

}
