/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NetworkGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 11946;
  }

  // Properties.
  protected final PascalString serverUri;
  protected final List<EndpointUrlListDataType> networkPaths;

  public NetworkGroupDataType(PascalString serverUri, List<EndpointUrlListDataType> networkPaths) {
    super();
    this.serverUri = serverUri;
    this.networkPaths = networkPaths;
  }

  public PascalString getServerUri() {
    return serverUri;
  }

  public List<EndpointUrlListDataType> getNetworkPaths() {
    return networkPaths;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NetworkGroupDataType");

    // Simple Field (serverUri)
    writeSimpleField("serverUri", serverUri, writeComplex(writeBuffer));

    // Implicit Field (noOfNetworkPaths) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfNetworkPaths =
        (int) ((((getNetworkPaths()) == (null)) ? -(1) : COUNT(getNetworkPaths())));
    writeImplicitField("noOfNetworkPaths", noOfNetworkPaths, writeSignedInt(writeBuffer, 32));

    // Array Field (networkPaths)
    writeComplexTypeArrayField("networkPaths", networkPaths, writeBuffer);

    writeBuffer.popContext("NetworkGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NetworkGroupDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (serverUri)
    lengthInBits += serverUri.getLengthInBits();

    // Implicit Field (noOfNetworkPaths)
    lengthInBits += 32;

    // Array field
    if (networkPaths != null) {
      int i = 0;
      for (EndpointUrlListDataType element : networkPaths) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= networkPaths.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("NetworkGroupDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString serverUri =
        readSimpleField(
            "serverUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfNetworkPaths = readImplicitField("noOfNetworkPaths", readSignedInt(readBuffer, 32));

    List<EndpointUrlListDataType> networkPaths =
        readCountArrayField(
            "networkPaths",
            readComplex(
                () ->
                    (EndpointUrlListDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (11945)),
                readBuffer),
            noOfNetworkPaths);

    readBuffer.closeContext("NetworkGroupDataType");
    // Create the instance
    return new NetworkGroupDataTypeBuilderImpl(serverUri, networkPaths);
  }

  public static class NetworkGroupDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString serverUri;
    private final List<EndpointUrlListDataType> networkPaths;

    public NetworkGroupDataTypeBuilderImpl(
        PascalString serverUri, List<EndpointUrlListDataType> networkPaths) {
      this.serverUri = serverUri;
      this.networkPaths = networkPaths;
    }

    public NetworkGroupDataType build() {
      NetworkGroupDataType networkGroupDataType = new NetworkGroupDataType(serverUri, networkPaths);
      return networkGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NetworkGroupDataType)) {
      return false;
    }
    NetworkGroupDataType that = (NetworkGroupDataType) o;
    return (getServerUri() == that.getServerUri())
        && (getNetworkPaths() == that.getNetworkPaths())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getServerUri(), getNetworkPaths());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
