/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataTamperOff is the corresponding interface of SecurityDataTamperOff
type SecurityDataTamperOff interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataTamperOff is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataTamperOff()
	// CreateBuilder creates a SecurityDataTamperOffBuilder
	CreateSecurityDataTamperOffBuilder() SecurityDataTamperOffBuilder
}

// _SecurityDataTamperOff is the data-structure of this message
type _SecurityDataTamperOff struct {
	SecurityDataContract
}

var _ SecurityDataTamperOff = (*_SecurityDataTamperOff)(nil)
var _ SecurityDataRequirements = (*_SecurityDataTamperOff)(nil)

// NewSecurityDataTamperOff factory function for _SecurityDataTamperOff
func NewSecurityDataTamperOff(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataTamperOff {
	_result := &_SecurityDataTamperOff{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataTamperOffBuilder is a builder for SecurityDataTamperOff
type SecurityDataTamperOffBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataTamperOffBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataTamperOff or returns an error if something is wrong
	Build() (SecurityDataTamperOff, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataTamperOff
}

// NewSecurityDataTamperOffBuilder() creates a SecurityDataTamperOffBuilder
func NewSecurityDataTamperOffBuilder() SecurityDataTamperOffBuilder {
	return &_SecurityDataTamperOffBuilder{_SecurityDataTamperOff: new(_SecurityDataTamperOff)}
}

type _SecurityDataTamperOffBuilder struct {
	*_SecurityDataTamperOff

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataTamperOffBuilder) = (*_SecurityDataTamperOffBuilder)(nil)

func (b *_SecurityDataTamperOffBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataTamperOff
}

func (b *_SecurityDataTamperOffBuilder) WithMandatoryFields() SecurityDataTamperOffBuilder {
	return b
}

func (b *_SecurityDataTamperOffBuilder) Build() (SecurityDataTamperOff, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataTamperOff.deepCopy(), nil
}

func (b *_SecurityDataTamperOffBuilder) MustBuild() SecurityDataTamperOff {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataTamperOffBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataTamperOffBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataTamperOffBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataTamperOffBuilder().(*_SecurityDataTamperOffBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataTamperOffBuilder creates a SecurityDataTamperOffBuilder
func (b *_SecurityDataTamperOff) CreateSecurityDataTamperOffBuilder() SecurityDataTamperOffBuilder {
	if b == nil {
		return NewSecurityDataTamperOffBuilder()
	}
	return &_SecurityDataTamperOffBuilder{_SecurityDataTamperOff: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataTamperOff) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataTamperOff(structType any) SecurityDataTamperOff {
	if casted, ok := structType.(SecurityDataTamperOff); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataTamperOff); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataTamperOff) GetTypeName() string {
	return "SecurityDataTamperOff"
}

func (m *_SecurityDataTamperOff) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataTamperOff) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataTamperOff) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataTamperOff SecurityDataTamperOff, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataTamperOff"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataTamperOff")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataTamperOff"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataTamperOff")
	}

	return m, nil
}

func (m *_SecurityDataTamperOff) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataTamperOff) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataTamperOff"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataTamperOff")
		}

		if popErr := writeBuffer.PopContext("SecurityDataTamperOff"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataTamperOff")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataTamperOff) IsSecurityDataTamperOff() {}

func (m *_SecurityDataTamperOff) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataTamperOff) deepCopy() *_SecurityDataTamperOff {
	if m == nil {
		return nil
	}
	_SecurityDataTamperOffCopy := &_SecurityDataTamperOff{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataTamperOffCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataTamperOffCopy
}

func (m *_SecurityDataTamperOff) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
