/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCredentialDataInputAll is the corresponding interface of BACnetConstructedDataCredentialDataInputAll
type BACnetConstructedDataCredentialDataInputAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataCredentialDataInputAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCredentialDataInputAll()
	// CreateBuilder creates a BACnetConstructedDataCredentialDataInputAllBuilder
	CreateBACnetConstructedDataCredentialDataInputAllBuilder() BACnetConstructedDataCredentialDataInputAllBuilder
}

// _BACnetConstructedDataCredentialDataInputAll is the data-structure of this message
type _BACnetConstructedDataCredentialDataInputAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataCredentialDataInputAll = (*_BACnetConstructedDataCredentialDataInputAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCredentialDataInputAll)(nil)

// NewBACnetConstructedDataCredentialDataInputAll factory function for _BACnetConstructedDataCredentialDataInputAll
func NewBACnetConstructedDataCredentialDataInputAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCredentialDataInputAll {
	_result := &_BACnetConstructedDataCredentialDataInputAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCredentialDataInputAllBuilder is a builder for BACnetConstructedDataCredentialDataInputAll
type BACnetConstructedDataCredentialDataInputAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataCredentialDataInputAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCredentialDataInputAll or returns an error if something is wrong
	Build() (BACnetConstructedDataCredentialDataInputAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCredentialDataInputAll
}

// NewBACnetConstructedDataCredentialDataInputAllBuilder() creates a BACnetConstructedDataCredentialDataInputAllBuilder
func NewBACnetConstructedDataCredentialDataInputAllBuilder() BACnetConstructedDataCredentialDataInputAllBuilder {
	return &_BACnetConstructedDataCredentialDataInputAllBuilder{_BACnetConstructedDataCredentialDataInputAll: new(_BACnetConstructedDataCredentialDataInputAll)}
}

type _BACnetConstructedDataCredentialDataInputAllBuilder struct {
	*_BACnetConstructedDataCredentialDataInputAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCredentialDataInputAllBuilder) = (*_BACnetConstructedDataCredentialDataInputAllBuilder)(nil)

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCredentialDataInputAll
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) WithMandatoryFields() BACnetConstructedDataCredentialDataInputAllBuilder {
	return b
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) Build() (BACnetConstructedDataCredentialDataInputAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCredentialDataInputAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) MustBuild() BACnetConstructedDataCredentialDataInputAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCredentialDataInputAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCredentialDataInputAllBuilder().(*_BACnetConstructedDataCredentialDataInputAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCredentialDataInputAllBuilder creates a BACnetConstructedDataCredentialDataInputAllBuilder
func (b *_BACnetConstructedDataCredentialDataInputAll) CreateBACnetConstructedDataCredentialDataInputAllBuilder() BACnetConstructedDataCredentialDataInputAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataCredentialDataInputAllBuilder()
	}
	return &_BACnetConstructedDataCredentialDataInputAllBuilder{_BACnetConstructedDataCredentialDataInputAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCredentialDataInputAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_CREDENTIAL_DATA_INPUT
}

func (m *_BACnetConstructedDataCredentialDataInputAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCredentialDataInputAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCredentialDataInputAll(structType any) BACnetConstructedDataCredentialDataInputAll {
	if casted, ok := structType.(BACnetConstructedDataCredentialDataInputAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCredentialDataInputAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCredentialDataInputAll) GetTypeName() string {
	return "BACnetConstructedDataCredentialDataInputAll"
}

func (m *_BACnetConstructedDataCredentialDataInputAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataCredentialDataInputAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCredentialDataInputAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCredentialDataInputAll BACnetConstructedDataCredentialDataInputAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCredentialDataInputAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCredentialDataInputAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCredentialDataInputAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCredentialDataInputAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCredentialDataInputAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCredentialDataInputAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCredentialDataInputAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCredentialDataInputAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCredentialDataInputAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCredentialDataInputAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCredentialDataInputAll) IsBACnetConstructedDataCredentialDataInputAll() {
}

func (m *_BACnetConstructedDataCredentialDataInputAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCredentialDataInputAll) deepCopy() *_BACnetConstructedDataCredentialDataInputAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCredentialDataInputAllCopy := &_BACnetConstructedDataCredentialDataInputAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataCredentialDataInputAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCredentialDataInputAllCopy
}

func (m *_BACnetConstructedDataCredentialDataInputAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
