/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.region.EquinoxStateHelper;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

final class StandardRegionFilter
implements RegionFilter {
    private static final String BUNDLE_ID_ATTR = "id";
    private final Map<String, Collection<Filter>> filters;

    StandardRegionFilter(Map<String, Collection<Filter>> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters must not be null.");
        }
        this.filters = new HashMap<String, Collection<Filter>>((int)((double)filters.size() / 0.75 + 1.0));
        for (Map.Entry<String, Collection<Filter>> namespace : filters.entrySet()) {
            ArrayList<Filter> namespaceFilters = new ArrayList<Filter>(namespace.getValue());
            this.filters.put(namespace.getKey(), namespaceFilters);
        }
    }

    @Override
    public boolean isAllowed(Bundle bundle) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(3);
        String bsn = bundle.getSymbolicName();
        if (bsn != null) {
            attrs.put("org.eclipse.equinox.allow.bundle", bsn);
            attrs.put("bundle-symbolic-name", bsn);
        }
        attrs.put("bundle-version", bundle.getVersion());
        attrs.put(BUNDLE_ID_ATTR, bundle.getBundleId());
        return this.isBundleAllowed(attrs);
    }

    @Override
    public boolean isAllowed(BundleRevision bundle) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(3);
        String bsn = bundle.getSymbolicName();
        if (bsn != null) {
            attrs.put("org.eclipse.equinox.allow.bundle", bsn);
        }
        attrs.put("bundle-version", bundle.getVersion());
        attrs.put(BUNDLE_ID_ATTR, this.getBundleId(bundle));
        return this.isBundleAllowed(attrs);
    }

    private boolean isBundleAllowed(Map<String, ?> bundleAttributes) {
        return this.isAllowed("org.eclipse.equinox.allow.bundle", bundleAttributes);
    }

    private static boolean match(Collection<Filter> filters, Map<String, ?> attrs) {
        if (filters == null) {
            return false;
        }
        for (Filter filter : filters) {
            if (!filter.matches(attrs)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(Collection<Filter> filters, ServiceReference<?> service) {
        if (filters == null) {
            return false;
        }
        for (Filter filter : filters) {
            if (!filter.match(service)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllowed(ServiceReference<?> service) {
        if (StandardRegionFilter.match(this.filters.get("org.eclipse.equinox.allow.service"), service)) {
            return true;
        }
        return StandardRegionFilter.match(this.filters.get("org.eclipse.equinox.allow.all"), service);
    }

    @Override
    public boolean isAllowed(BundleCapability capability) {
        return this.isAllowed(capability.getNamespace(), capability.getAttributes());
    }

    @Override
    public boolean isAllowed(String namespace, Map<String, ?> attributes) {
        if (StandardRegionFilter.match(this.filters.get(namespace), attributes)) {
            return true;
        }
        return StandardRegionFilter.match(this.filters.get("org.eclipse.equinox.allow.all"), attributes);
    }

    @Override
    public Map<String, Collection<String>> getSharingPolicy() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>((int)((double)this.filters.size() / 0.75 + 1.0));
        for (Map.Entry<String, Collection<Filter>> namespace : this.filters.entrySet()) {
            result.put(namespace.getKey(), StandardRegionFilter.getFilters(namespace.getValue()));
        }
        return result;
    }

    private static Collection<String> getFilters(Collection<Filter> filters) {
        ArrayList<String> result = new ArrayList<String>(filters.size());
        for (Filter filter : filters) {
            result.add(filter.toString());
        }
        return result;
    }

    public String toString() {
        return this.getSharingPolicy().toString();
    }

    private Long getBundleId(BundleRevision bundleRevision) {
        return EquinoxStateHelper.getBundleId(bundleRevision);
    }
}

