/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.gradle;

import de.thetaphi.forbiddenapis.gradle.CheckForbiddenApisExtension;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.GradleVersion;

abstract class ForbiddenApisPluginBase
implements Plugin<Project> {
    private static final Logger LOG = Logging.getLogger(ForbiddenApisPluginBase.class);
    public static final String FORBIDDEN_APIS_TASK_NAME = "forbiddenApis";
    public static final String FORBIDDEN_APIS_EXTENSION_NAME = "forbiddenApis";
    public static final boolean DEFAULT_DISABLE_CLASSLOADING_CACHE = ForbiddenApisPluginBase.detectAndLogGradleDaemon();
    public static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"3.2");
    public static final boolean TASK_AVOIDANCE_AVAILABLE = GradleVersion.current().compareTo(GradleVersion.version((String)"4.9")) >= 0;
    protected static final List<String> FORBIDDEN_APIS_EXTENSION_PROPS = ForbiddenApisPluginBase.determineExtensionProps();
    private static final String GRADLE_DAEMON_PACKAGE = "org.gradle.launcher.daemon.";

    ForbiddenApisPluginBase() {
    }

    private static List<String> determineExtensionProps() {
        ArrayList<String> props = new ArrayList<String>();
        for (Field f : CheckForbiddenApisExtension.class.getDeclaredFields()) {
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods) || f.isSynthetic() || Modifier.isStatic(mods)) continue;
            props.add(f.getName());
        }
        return Collections.unmodifiableList(props);
    }

    private static boolean isGradleDaemon() {
        if (System.getProperty("sun.java.command", "").startsWith(GRADLE_DAEMON_PACKAGE)) {
            return true;
        }
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().startsWith(GRADLE_DAEMON_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    private static boolean detectAndLogGradleDaemon() {
        boolean daemon = ForbiddenApisPluginBase.isGradleDaemon();
        if (daemon) {
            LOG.info("You are running forbidden-apis in the Gradle Daemon; disabling classloading cache by default to work around resource leak.");
        }
        return daemon;
    }
}

