/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.regexp.LikePattern;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class LikeColumnTransformer
extends UnaryColumnTransformer {
    private final LikePattern pattern;

    public LikeColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, LikePattern pattern) {
        super(returnType, childColumnTransformer);
        this.pattern = pattern;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                Binary value = this.childColumnTransformer.getType().getBinary(column, i);
                this.returnType.writeBoolean(columnBuilder, this.pattern.getMatcher().match(value.getValues(), 0, value.getLength()));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                Binary value = this.childColumnTransformer.getType().getBinary(column, i);
                this.returnType.writeBoolean(columnBuilder, this.pattern.getMatcher().match(value.getValues(), 0, value.getLength()));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (!TableMetadataImpl.isCharType(this.childColumnTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.childColumnTransformer.getType().getTypeEnum());
        }
    }
}

