/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.sort;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.sort.SortBufferManager;
import org.apache.iotdb.db.utils.sort.SortReader;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;

public class FileSpillerReader
implements SortReader {
    private final FileChannel fileChannel;
    private final List<TsBlock> cacheBlocks;
    private final SortBufferManager sortBufferManager;
    private final String fileName;
    private final TsBlockSerde serde;
    private int tsBlockIndex;
    private int rowIndex;
    private boolean isEnd = false;
    private final int maxTsBlockSizeInBytes = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    public FileSpillerReader(String fileName, SortBufferManager sortBufferManager, TsBlockSerde serde) throws IOException {
        this.fileChannel = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
        this.cacheBlocks = new ArrayList<TsBlock>();
        this.rowIndex = 0;
        this.fileName = fileName;
        this.sortBufferManager = sortBufferManager;
        this.serde = serde;
    }

    @Override
    public MergeSortKey next() {
        MergeSortKey sortKey = new MergeSortKey(this.cacheBlocks.get(this.tsBlockIndex), this.rowIndex);
        ++this.rowIndex;
        return sortKey;
    }

    private boolean readTsBlockFromFile() throws IoTDBException {
        long size;
        this.cacheBlocks.clear();
        for (long bufferSize = this.sortBufferManager.getReaderBufferAvailable(); bufferSize >= (long)this.maxTsBlockSizeInBytes && (size = this.read()) != -1L; bufferSize -= size) {
        }
        if (this.cacheBlocks.isEmpty()) {
            return false;
        }
        this.rowIndex = 0;
        this.tsBlockIndex = 0;
        return true;
    }

    private long read() throws IoTDBException {
        try {
            ByteBuffer bytes = ByteBuffer.allocate(4);
            int readLen = this.fileChannel.read(bytes);
            if (readLen == -1) {
                return -1L;
            }
            bytes.flip();
            int capacity = bytes.getInt();
            ByteBuffer tsBlockBytes = ByteBuffer.allocate(capacity);
            this.fileChannel.read(tsBlockBytes);
            tsBlockBytes.flip();
            TsBlock cachedTsBlock = this.serde.deserialize(tsBlockBytes);
            this.cacheBlocks.add(cachedTsBlock);
            return cachedTsBlock.getRetainedSizeInBytes();
        }
        catch (IOException e) {
            throw new IoTDBException("Can't read a new tsBlock in FileSpillerReader: " + this.fileName, (Throwable)e, TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public boolean hasNext() throws IoTDBException {
        if (this.isEnd) {
            return false;
        }
        if (this.cacheBlocks.isEmpty() || this.rowIndex == this.cacheBlocks.get(this.tsBlockIndex).getPositionCount() && this.tsBlockIndex == this.cacheBlocks.size() - 1) {
            boolean hasData = this.readTsBlockFromFile();
            if (!hasData) {
                this.isEnd = true;
                return false;
            }
            return true;
        }
        if (this.rowIndex < this.cacheBlocks.get(this.tsBlockIndex).getPositionCount()) {
            return true;
        }
        ++this.tsBlockIndex;
        this.rowIndex = 0;
        return true;
    }

    @Override
    public void close() throws IoTDBException {
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new IoTDBException("Can't close fileChannel in FileSpillerReader: " + this.fileName, (Throwable)e, TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }
}

