/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeSubscribeReq
extends TPipeSubscribeReq {
    private transient Set<String> topicNames = new HashSet<String>();

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public static PipeSubscribeSubscribeReq toTPipeSubscribeReq(Set<String> topicNames) throws IOException {
        PipeSubscribeSubscribeReq req = new PipeSubscribeSubscribeReq();
        req.topicNames = topicNames;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.SUBSCRIBE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.writeObjectSet(topicNames, (DataOutputStream)outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribeSubscribeReq fromTPipeSubscribeReq(TPipeSubscribeReq subscribeReq) {
        PipeSubscribeSubscribeReq req = new PipeSubscribeSubscribeReq();
        if (Objects.nonNull(subscribeReq.body) && subscribeReq.body.hasRemaining()) {
            req.topicNames = ReadWriteIOUtils.readObjectSet((ByteBuffer)subscribeReq.body);
        }
        req.version = subscribeReq.version;
        req.type = subscribeReq.type;
        req.body = subscribeReq.body;
        return req;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeSubscribeReq that = (PipeSubscribeSubscribeReq)((Object)obj);
        return Objects.equals(this.topicNames, that.topicNames) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.topicNames, this.version, this.type, this.body);
    }
}

