/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import org.apache.iotdb.cluster.client.BaseFactory;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBaseFactory<K, T extends RaftService.AsyncClient>
extends BaseFactory<K, T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncBaseFactory.class);

    protected AsyncBaseFactory(TProtocolFactory protocolFactory, ClientCategory category) {
        super(protocolFactory, category);
        this.managers = new TAsyncClientManager[ClusterDescriptor.getInstance().getConfig().getSelectorNumOfClientPool()];
        for (int i = 0; i < this.managers.length; ++i) {
            try {
                this.managers[i] = new TAsyncClientManager();
                continue;
            }
            catch (IOException e) {
                logger.error("Cannot create data heartbeat client manager for factory", (Throwable)e);
            }
        }
    }

    protected AsyncBaseFactory(TProtocolFactory protocolFactory, ClientCategory category, IClientManager clientManager) {
        super(protocolFactory, category, clientManager);
        this.managers = new TAsyncClientManager[ClusterDescriptor.getInstance().getConfig().getSelectorNumOfClientPool()];
        for (int i = 0; i < this.managers.length; ++i) {
            try {
                this.managers[i] = new TAsyncClientManager();
                continue;
            }
            catch (IOException e) {
                logger.error("Cannot create data heartbeat client manager for factory", (Throwable)e);
            }
        }
    }
}

