/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.catalog;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.system.SystemTableLoader;

public abstract class AbstractCatalog
implements Catalog {
    protected static final String DB_SUFFIX = ".db";

    @Override
    public Path getTableLocation(ObjectPath tablePath) {
        if (tablePath.getObjectName().contains("$")) {
            throw new IllegalArgumentException(String.format("Table name[%s] cannot contain '%s' separator", tablePath.getObjectName(), "$"));
        }
        return new Path(this.databasePath(tablePath.getDatabaseName()), tablePath.getObjectName());
    }

    @Override
    public Table getTable(ObjectPath tablePath) throws Catalog.TableNotExistException {
        String inputTableName = tablePath.getObjectName();
        if (inputTableName.contains("$")) {
            String[] splits = StringUtils.split((String)inputTableName, (String)"$");
            if (splits.length != 2) {
                throw new IllegalArgumentException("System table can only contain one '$' separator, but this is: " + inputTableName);
            }
            String table = splits[0];
            String type = splits[1];
            ObjectPath originTablePath = new ObjectPath(tablePath.getDatabaseName(), table);
            if (!this.tableExists(originTablePath)) {
                throw new Catalog.TableNotExistException(tablePath);
            }
            Path location = this.getTableLocation(originTablePath);
            return SystemTableLoader.load(type, location);
        }
        TableSchema tableSchema = this.getTableSchema(tablePath);
        return FileStoreTableFactory.create(this.getTableLocation(tablePath), tableSchema);
    }

    protected Path databasePath(String database) {
        return new Path(this.warehouse(), database + DB_SUFFIX);
    }

    protected abstract String warehouse();
}

