/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.ParquetDictionary;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.RunLengthDecoder;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.BytesInput;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.BytesUtils;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.Dictionary;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ValuesType;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPage;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPageV1;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DataPageV2;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DictionaryPage;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.PageReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.values.ValuesReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.ParquetDecodingException;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnReader<VECTOR extends WritableColumnVector>
implements ColumnReader<VECTOR> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractColumnReader.class);
    private final PageReader pageReader;
    protected final Dictionary dictionary;
    protected final int maxDefLevel;
    protected final ColumnDescriptor descriptor;
    private long valuesRead;
    private long endOfPageValueCount;
    private boolean isCurrentPageDictionaryEncoded;
    private int pageValueCount;
    protected RunLengthDecoder runLenDecoder;
    ByteBufferInputStream dataInputStream;
    private RunLengthDecoder dictionaryIdsDecoder;

    public AbstractColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        long totalValueCount = pageReader.getTotalValueCount();
        if (totalValueCount == 0L) {
            throw new IOException("totalValueCount == 0");
        }
    }

    protected void checkTypeName(PrimitiveType.PrimitiveTypeName expectedName) {
        PrimitiveType.PrimitiveTypeName actualName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
        Preconditions.checkArgument(actualName == expectedName, "Expected type name: %s, actual type name: %s", new Object[]{expectedName, actualName});
    }

    @Override
    public final void readToVector(int readNumber, VECTOR vector) throws IOException {
        int rowId = 0;
        WritableIntVector dictionaryIds = null;
        if (this.dictionary != null) {
            dictionaryIds = vector.reserveDictionaryIds(readNumber);
        }
        while (readNumber > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                DataPage page = this.pageReader.readPage();
                if (page instanceof DataPageV1) {
                    this.readPageV1((DataPageV1)page);
                } else if (page instanceof DataPageV2) {
                    this.readPageV2((DataPageV2)page);
                } else {
                    throw new RuntimeException("Unsupported page type: " + page.getClass());
                }
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(readNumber, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                this.runLenDecoder.readDictionaryIds(num, dictionaryIds, (WritableColumnVector)vector, rowId, this.maxDefLevel, this.dictionaryIdsDecoder);
                if (vector.hasDictionary() || rowId == 0 && this.supportLazyDecode()) {
                    vector.setDictionary((org.apache.flink.table.data.columnar.vector.Dictionary)new ParquetDictionary(this.dictionary));
                } else {
                    this.readBatchFromDictionaryIds(rowId, num, vector, dictionaryIds);
                }
            } else {
                if (vector.hasDictionary() && rowId != 0) {
                    this.readBatchFromDictionaryIds(0, rowId, vector, vector.getDictionaryIds());
                }
                vector.setDictionary(null);
                this.readBatch(rowId, num, vector);
            }
            this.valuesRead += (long)num;
            rowId += num;
            readNumber -= num;
        }
    }

    private void readPageV1(DataPageV1 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)page.getDlEncoding()));
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.runLenDecoder = new RunLengthDecoder(bitWidth);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            rlReader.initFromPage(this.pageValueCount, in);
            this.runLenDecoder.initFromStream(this.pageValueCount, in);
            this.prepareNewPage(page.getValueEncoding(), in);
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void readPageV2(DataPageV2 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        int bitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.runLenDecoder = new RunLengthDecoder(bitWidth, false);
        this.runLenDecoder.initFromStream(this.pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.prepareNewPage(page.getDataEncoding(), page.getData().toInputStream());
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void prepareNewPage(Encoding dataEncoding, ByteBufferInputStream in) throws IOException {
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)dataEncoding));
            }
            this.dataInputStream = null;
            this.dictionaryIdsDecoder = new RunLengthDecoder();
            try {
                this.dictionaryIdsDecoder.initFromStream(this.pageValueCount, in);
            }
            catch (IOException e) {
                throw new IOException("could not read dictionary in col " + this.descriptor, e);
            }
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)dataEncoding));
            }
            this.dictionaryIdsDecoder = null;
            LOG.debug("init from page at offset {} for length {}", (Object)in.position(), (Object)in.available());
            this.dataInputStream = in.remainingStream();
            this.isCurrentPageDictionaryEncoded = false;
        }
        this.afterReadPage();
    }

    final ByteBuffer readDataBuffer(int length) {
        try {
            return this.dataInputStream.slice(length).order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes", e);
        }
    }

    protected void afterReadPage() {
    }

    protected boolean supportLazyDecode() {
        return true;
    }

    protected abstract void readBatch(int var1, int var2, VECTOR var3);

    protected abstract void readBatchFromDictionaryIds(int var1, int var2, VECTOR var3, WritableIntVector var4);
}

