/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.store.table.sink.FileCommittable;

public class ManifestCommittable {
    private final long identifier;
    private final Map<Integer, Long> logOffsets;
    private final List<FileCommittable> fileCommittables;

    public ManifestCommittable(long identifier) {
        this.identifier = identifier;
        this.logOffsets = new HashMap<Integer, Long>();
        this.fileCommittables = new ArrayList<FileCommittable>();
    }

    public ManifestCommittable(long identifier, Map<Integer, Long> logOffsets, List<FileCommittable> fileCommittables) {
        this.identifier = identifier;
        this.logOffsets = logOffsets;
        this.fileCommittables = fileCommittables;
    }

    public void addFileCommittable(FileCommittable fileCommittable) {
        this.fileCommittables.add(fileCommittable);
    }

    public void addLogOffset(int bucket, long offset) {
        if (this.logOffsets.containsKey(bucket)) {
            throw new RuntimeException(String.format("bucket-%d appears multiple times, which is not possible.", bucket));
        }
        this.logOffsets.put(bucket, offset);
    }

    public long identifier() {
        return this.identifier;
    }

    public Map<Integer, Long> logOffsets() {
        return this.logOffsets;
    }

    public List<FileCommittable> fileCommittables() {
        return this.fileCommittables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestCommittable that = (ManifestCommittable)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.logOffsets, that.logOffsets) && Objects.equals(this.fileCommittables, that.fileCommittables);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.logOffsets, this.fileCommittables);
    }

    public String toString() {
        return String.format("ManifestCommittable {identifier = %s, logOffsets = %s, fileCommittables = %s", this.identifier, this.logOffsets, this.fileCommittables);
    }
}

