/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;

@PublicEvolving
public class TextLineInputFormat
extends SimpleStreamFormat<String> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private final String charsetName;

    public TextLineInputFormat() {
        this(DEFAULT_CHARSET_NAME);
    }

    public TextLineInputFormat(String charsetName) {
        this.charsetName = charsetName;
    }

    public Reader createReader(Configuration config, FSDataInputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, this.charsetName));
        return new Reader(reader);
    }

    @Override
    public TypeInformation<String> getProducedType() {
        return Types.STRING;
    }

    @PublicEvolving
    public static final class Reader
    implements StreamFormat.Reader<String> {
        private final BufferedReader reader;

        Reader(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        @Nullable
        public String read() throws IOException {
            return this.reader.readLine();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

