/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

final class CompiledStatement {
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int SELECT_INTO = 6;
    static final int CALL = 7;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    int id;
    boolean isValid = true;
    Table targetTable;
    TableFilter targetFilter;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    String sql;
    final HsqlNameManager.HsqlName schemaHsqlName;
    private static final Result updateCountResult = new Result(1);

    CompiledStatement(HsqlNameManager.HsqlName hsqlName) {
        this.parameters = new Expression[0];
        this.paramTypes = new int[0];
        this.subqueries = new SubQuery[0];
        this.type = 9;
        this.schemaHsqlName = hsqlName;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName hsqlName, TableFilter tableFilter, Expression expression, SubQuery[] subQueryArray, Expression[] expressionArray) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.targetFilter = tableFilter;
        this.targetTable = tableFilter.filterTable;
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolveTables(tableFilter);
            this.condition.resolveTypes(session);
            tableFilter.setConditions(session, this.condition);
        }
        this.setParameters(expressionArray);
        this.setSubqueries(subQueryArray);
        this.type = 4;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName hsqlName, TableFilter tableFilter, int[] nArray, Expression[] expressionArray, Expression expression, SubQuery[] subQueryArray, Expression[] expressionArray2) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.targetFilter = tableFilter;
        this.targetTable = tableFilter.filterTable;
        this.columnMap = nArray;
        this.columnValues = expressionArray;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression2 = expressionArray[i];
            if (expression2.isParam()) {
                expression2.setTableColumnAttributes(this.targetTable, nArray[i]);
                continue;
            }
            expression2.resolveTables(tableFilter);
            expression2.resolveTypes(session);
        }
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolveTables(tableFilter);
            this.condition.resolveTypes(session);
            tableFilter.setConditions(session, this.condition);
        }
        this.setParameters(expressionArray2);
        this.setSubqueries(subQueryArray);
        this.type = 3;
    }

    CompiledStatement(HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, Expression[] expressionArray, boolean[] blArray, SubQuery[] subQueryArray, Expression[] expressionArray2) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.columnValues = expressionArray;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (!expression.isParam()) continue;
            expression.setTableColumnAttributes(table, nArray[i]);
        }
        this.setParameters(expressionArray2);
        this.setSubqueries(subQueryArray);
        this.type = 1;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, boolean[] blArray, Select select, SubQuery[] subQueryArray, Expression[] expressionArray) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.select = select;
        this.resolveInsertParameterTypes();
        select.prepareResult(session);
        this.setParameters(expressionArray);
        this.setSubqueries(subQueryArray);
        this.type = 2;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName hsqlName, Select select, SubQuery[] subQueryArray, Expression[] expressionArray) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.select = select;
        for (int i = 0; i < select.iResultLen; ++i) {
            Expression expression = select.exprColumns[i];
            if (expression.getDataType() != 0) continue;
            expression.setDataType(12);
        }
        select.prepareResult(session);
        this.setParameters(expressionArray);
        this.setSubqueries(subQueryArray);
        this.type = 5;
    }

    CompiledStatement(Session session, Database database, HsqlNameManager.HsqlName hsqlName, Expression expression, SubQuery[] subQueryArray, Expression[] expressionArray) throws HsqlException {
        this.schemaHsqlName = hsqlName;
        this.expression = expression;
        expression.resolveTypes(session);
        expression.paramMode = 4;
        this.setParameters(expressionArray);
        this.setSubqueries(subQueryArray);
        this.type = 7;
    }

    private void resolveInsertParameterTypes() {
        for (int i = 0; i < this.select.iResultLen; ++i) {
            Expression expression = this.select.exprColumns[i];
            if (expression.getDataType() != 0) continue;
            Column column = this.targetTable.getColumn(this.columnMap[i]);
            expression.setDataType(column.getType());
        }
    }

    private void setParameters(Expression[] expressionArray) {
        this.parameters = expressionArray;
        int[] nArray = new int[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            nArray[i] = this.parameters[i].getDataType();
        }
        this.paramTypes = nArray;
    }

    private void setSubqueries(SubQuery[] subQueryArray) {
        this.subqueries = subQueryArray;
    }

    void materializeSubQueries(Session session) throws HsqlException {
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery subQuery = this.subqueries[i];
            if (subQuery.isMaterialised || !subQuery.isResolved) continue;
            subQuery.populateTable(session);
            subQuery.isMaterialised = true;
        }
    }

    void dematerializeSubQueries(Session session) {
        if (this.subqueries == null) {
            return;
        }
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].table.clearAllRows(session);
            this.subqueries[i].isMaterialised = false;
        }
    }

    void clearVariables() {
        this.isValid = false;
        this.targetTable = null;
        this.targetFilter = null;
        this.condition = null;
        this.columnMap = null;
        this.columnValues = null;
        this.checkColumns = null;
        this.expression = null;
        this.select = null;
        this.parameters = null;
        this.paramTypes = null;
        this.subqueries = null;
    }

    boolean canExecute(Session session) throws HsqlException {
        switch (this.type) {
            case 5: 
            case 7: {
                for (int i = 0; i < this.select.tFilter.length; ++i) {
                    HsqlNameManager.HsqlName hsqlName = this.select.tFilter[i].filterTable.getName();
                    session.check(hsqlName, 1);
                }
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                session.check(this.targetTable.getName(), 2);
                break;
            }
            case 1: {
                session.check(this.targetTable.getName(), 4);
                break;
            }
            case 3: {
                session.check(this.targetTable.getName(), 8);
                break;
            }
        }
        return true;
    }

    void checkTableWriteAccess(Session session, Table table) throws HsqlException {
        session.checkReadWrite();
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    Result describeResult() {
        switch (this.type) {
            case 7: {
                Expression expression = this.expression;
                Result result = Result.newSingleColumnResult(RETURN_COLUMN_NAME, expression.getDataType());
                result.metaData.classNames[0] = expression.getValueClassName();
                return result;
            }
            case 5: {
                return this.select.sIntoTable == null ? this.select.describeResult() : updateCountResult;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return updateCountResult;
            }
        }
        return new Result(Trace.runtimeError(201, "CompiledStatement.describeResult()"), null);
    }

    Result describeParameters() {
        int n = this.parameters.length;
        int n2 = 0;
        Result result = Result.newParameterDescriptionResult(n);
        for (int i = 0; i < this.parameters.length; ++i) {
            Expression expression = this.parameters[i];
            int n3 = i + n2;
            result.metaData.colNames[n3] = PCOL_PREFIX + (i + 1);
            result.metaData.classNames[n3] = expression.getValueClassName();
            result.metaData.colTypes[n3] = expression.getDataType();
            result.metaData.colSizes[n3] = expression.getColumnSize();
            result.metaData.colScales[n3] = expression.getColumnScale();
            result.metaData.colNullable[n3] = expression.nullability;
            result.metaData.isIdentity[n3] = expression.isIdentity;
            result.metaData.paramMode[n3] = expression.paramMode;
        }
        return result;
    }

    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    private String describeImpl(Session session) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 5: {
                stringBuffer.append(this.select.describe(session));
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer);
                return stringBuffer.toString();
            }
            case 1: {
                stringBuffer.append("INSERT VALUES");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 2: {
                stringBuffer.append("INSERT SELECT");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                stringBuffer.append(this.select.describe(session)).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 3: {
                stringBuffer.append("UPDATE");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                stringBuffer.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("DELETE");
                stringBuffer.append('[').append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                stringBuffer.append(this.targetFilter.describe(session)).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 7: {
                stringBuffer.append("CALL");
                stringBuffer.append('[');
                stringBuffer.append(this.expression.describe(session)).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer stringBuffer) {
        stringBuffer.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            stringBuffer.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n');
            if (this.subqueries[i].select != null) {
                stringBuffer.append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode()));
            }
            stringBuffer.append("]");
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendTable(StringBuffer stringBuffer) {
        stringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendColumns(StringBuffer stringBuffer) {
        stringBuffer.append("COLUMNS=[");
        for (int i = 0; i < this.columnMap.length; ++i) {
            stringBuffer.append('\n').append(this.columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)this.columnMap[i]).columnName.name).append('[').append(this.columnValues[i]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendParms(StringBuffer stringBuffer) {
        stringBuffer.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuffer.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendCondition(Session session, StringBuffer stringBuffer) {
        return this.condition == null ? stringBuffer.append("CONDITION[]\n") : stringBuffer.append("CONDITION[").append(this.condition.describe(session)).append("]\n");
    }
}

