/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import java.util.List;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class ProcedureValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        List<ProcedureParameter> parameters;
        Procedure procedure = (Procedure)treeNodePath.getObject();
        this.validateName(procedure, treeNodePath, validator);
        if (procedure.isReturningValue() && (parameters = procedure.getCallParameters()).size() == 0) {
            validator.registerWarning("Procedure returns a value, but has no parameters.", treeNodePath);
        }
    }

    protected void validateName(Procedure procedure, ProjectPath path, Validator validator) {
        String name = procedure.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed Procedure.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (Procedure otherProcedure : map.getProcedures()) {
            if (otherProcedure == procedure || !name.equals(otherProcedure.getName())) continue;
            validator.registerError("Duplicate Procedure name: " + name + ".", path);
            break;
        }
    }
}

