/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store;

import java.util.Collection;
import java.util.Iterator;

import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractExtent;
import org.datanucleus.store.query.Query;

/**
 * Extent that does a simple JDOQL query for the candidate with/without subclasses.
 */
public class DefaultCandidateExtent extends AbstractExtent
{
    /** FetchPlan for use with this Extent. */
    private FetchPlan fetchPlan = null;

    /** Underlying query for getting the Extent. */
    private Query query;

    /**
     * Constructor.
     * @param om Object Manager
     * @param cls candidate class
     * @param subclasses Whether to include subclasses
     * @param cmd MetaData for the candidate class
     */
    public DefaultCandidateExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd)
    {
        super(om, cls, subclasses, cmd);
        this.fetchPlan = om.getFetchPlan().getCopy();

        query = om.newQuery();
        query.setClass(cls);
        query.setSubclasses(subclasses);
    }

    public Iterator iterator()
    {
        return ((Collection)query.execute()).iterator();
    }

    public boolean hasSubclasses()
    {
        return subclasses;
    }

    public ObjectManager getObjectManager()
    {
        return om;
    }

    public FetchPlan getFetchPlan()
    {
        return fetchPlan;
    }

    public void closeAll()
    {
        query.closeAll();
    }

    public void close(Iterator iterator)
    {
        query.close(iterator);
    }
}