/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.Commands;
import com.google.cloud.sql.tool.Context;
import com.google.cloud.sql.tool.Log;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandProcessor {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\s*(\\\\\\w|\\S*)\\s*");
    private final Commands commands;
    private final Context context;

    CommandProcessor(Commands commands, Context context) {
        this.commands = commands;
        this.context = context;
    }

    Command.Result processCommand(String line) throws CommandException {
        Matcher matcher = WORD_PATTERN.matcher(line);
        if (!matcher.find()) {
            Log.vlog("Unknown command: " + line, new Object[0]);
            return Command.Result.NOT_COMMAND;
        }
        String first = matcher.group().trim();
        Command command = this.commands.getCommand(first);
        if (command == null) {
            return Command.Result.NOT_COMMAND;
        }
        ArrayList<String> args = Lists.newArrayList();
        while (matcher.find()) {
            String arg = matcher.group().trim();
            if (arg.isEmpty()) continue;
            args.add(arg);
        }
        return command.execute(args, this.context);
    }
}

