/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.auth.oauth2.draft10.AccessTokenErrorResponse;
import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.auth.oauth2.draft10.AccessTokenResponse;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.AccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import java.io.IOException;

public class RefreshTokenAccessTokenRefresher
implements AccessTokenRefresher {
    private final JsonFactory jsonFactory = new JacksonFactory();

    @Override
    public OAuthTokens refreshAccessToken(OAuthTokens ot, HttpTransport transport, Url url) throws IOException {
        Preconditions.checkNotNull(ot.getRefreshToken(), "No refresh token.");
        HttpResponse response = null;
        try {
            AccessTokenRequest.RefreshTokenGrant request = new AccessTokenRequest.RefreshTokenGrant(transport, this.jsonFactory, url.getOAuth2TokenUrl(), ot.getOAuth2ClientId(), ot.getOAuth2ClientSecret(), ot.getRefreshToken());
            request.useBasicAuthorization = false;
            response = request.executeUnparsed();
            AccessTokenResponse tokenResponse = response.parseAs(AccessTokenResponse.class);
            return OAuthTokens.fromUrl(url).withResponse(tokenResponse);
        }
        catch (HttpResponseException e) {
            try {
                AccessTokenErrorResponse tokenErrorResponse = e.getResponse().parseAs(AccessTokenErrorResponse.class);
                throw new OAuth2AuthorizationException(tokenErrorResponse, e);
            }
            catch (IllegalArgumentException iae) {
                throw RefreshTokenAccessTokenRefresher.newIOExceptionFromHttpReponse(e.getResponse());
            }
        }
        catch (IllegalArgumentException iae) {
            throw RefreshTokenAccessTokenRefresher.newIOExceptionFromHttpReponse(response);
        }
    }

    private static IOException newIOExceptionFromHttpReponse(HttpResponse response) throws IOException {
        String text = StringUtil.stripHtmlTags(response.parseAsString());
        int statusCode = response.getStatusCode();
        return new IOException(String.format("HTTP %d: Exception from server: '%s'", statusCode, text));
    }

    private static class OAuth2AuthorizationException
    extends IOException {
        private static final String INVALID_GRANT_MESSAGE = "The OAuth2 refresh token is not valid. Please delete it and try again. See https://code.google.com/apis/sqlservice/commandline.html#authentication";

        private OAuth2AuthorizationException(AccessTokenErrorResponse response, HttpResponseException e) {
            super(OAuth2AuthorizationException.createMessage(response), e);
        }

        private static String createMessage(AccessTokenErrorResponse response) {
            AccessTokenErrorResponse.KnownError error;
            StringBuilder msg = new StringBuilder(response.error).append(": ");
            if (!Util.isEmpty(response.errorDescription)) {
                msg.append(response.errorDescription).append('\n');
            }
            if (AccessTokenErrorResponse.KnownError.INVALID_GRANT == (error = response.getErrorCodeIfKnown())) {
                msg.append(INVALID_GRANT_MESSAGE);
            }
            return msg.toString();
        }
    }
}

