/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.cloud.sql.jdbc.internal.SqlClient;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import com.google.cloud.sql.jdbc.internal.SqlProtoClient;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.AccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.RefreshTokenAccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.RpcGoogleApi;
import java.util.Map;
import java.util.prefs.Preferences;

public final class GoogleApiClientFactory
implements SqlClientFactory {
    private static final Object LOCK = new Object();
    private static Map<UrlAndAccessTokenRefresher, RpcGoogleApi> rpcMap = Util.newHashMap();
    private final AccessTokenRefresher accessTokenRefresher;
    private final RpcGoogleApi.TokenCachePolicy cachePolicy;
    private final Preferences prefs;
    private final HttpTransport transport;

    public GoogleApiClientFactory() {
        this(new RefreshTokenAccessTokenRefresher(), new NetHttpTransport(), RpcGoogleApi.TokenCachePolicy.CACHE_NONE, null);
    }

    public GoogleApiClientFactory(AccessTokenRefresher accessTokenRefresher, HttpTransport transport, RpcGoogleApi.TokenCachePolicy cachePolicy, Preferences prefs) {
        this.accessTokenRefresher = Util.checkNotNull(accessTokenRefresher, "accessTokenRefresher cannot be null");
        this.transport = Util.checkNotNull(transport, "transport can not bt null");
        this.cachePolicy = Util.checkNotNull(cachePolicy, "cachePolicy can not be null");
        this.prefs = prefs;
    }

    @Override
    public SqlClient create(Url url) {
        return new SqlProtoClient(url.getInstance(), GoogleApiClientFactory.getRpc(this.accessTokenRefresher, url, this.transport, this.cachePolicy, this.prefs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RpcGoogleApi getRpc(AccessTokenRefresher accessTokenRefresher, Url url, HttpTransport transport, RpcGoogleApi.TokenCachePolicy cachePolicy, Preferences prefs) {
        Object object = LOCK;
        synchronized (object) {
            UrlAndAccessTokenRefresher key = new UrlAndAccessTokenRefresher(url, accessTokenRefresher);
            RpcGoogleApi api = rpcMap.get(key);
            if (api == null) {
                api = new RpcGoogleApi(accessTokenRefresher, url, transport, cachePolicy, prefs);
                rpcMap.put(key, api);
            }
            return api;
        }
    }

    private static class UrlAndAccessTokenRefresher {
        private final Url url;
        private final AccessTokenRefresher accessTokenRefresher;

        public UrlAndAccessTokenRefresher(Url url, AccessTokenRefresher accessTokenRefresher) {
            this.url = Util.checkNotNull(url, "url can not be null");
            this.accessTokenRefresher = Util.checkNotNull(accessTokenRefresher, "accessTokenRefresher can not be null");
        }

        public int hashCode() {
            return Objects.hashCode(this.url, this.accessTokenRefresher);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!o.getClass().equals(this.getClass())) {
                return false;
            }
            UrlAndAccessTokenRefresher other = (UrlAndAccessTokenRefresher)o;
            return Objects.equal(this.url, other.url) && Objects.equal(this.accessTokenRefresher, other.accessTokenRefresher);
        }
    }
}

