/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.json.JsonEncoding;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

public class JsonHttpContent
extends AbstractHttpContent {
    private String contentType = "application/json";
    private final Object data;
    private final JsonFactory jsonFactory;

    public JsonHttpContent(JsonFactory jsonFactory, Object data) {
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.data = Preconditions.checkNotNull(data);
    }

    @Override
    public String getType() {
        return this.contentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        JsonGenerator generator = this.jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8);
        generator.serialize(this.data);
        generator.flush();
    }

    public JsonHttpContent setType(String type) {
        this.contentType = type;
        return this;
    }

    public final Object getData() {
        return this.data;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }
}

