/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppEngineFile
implements Serializable {
    private static final String fullPathRegex = "^/([^/]+)/(.+)$";
    private static final Pattern fullPathPattern = Pattern.compile("^/([^/]+)/(.+)$");
    private String namePart;
    private String fullPath;
    private FileSystem fileSystem;
    private BlobKey cachedBlobKey;

    public AppEngineFile(FileSystem fileSystem, String namePart) {
        this("/" + fileSystem.getName() + "/" + AppEngineFile.checkNamePart(namePart), fileSystem, namePart);
    }

    private static String checkNamePart(String namePart) {
        Preconditions.checkNotNull(namePart, "namePart");
        namePart = namePart.trim();
        Preconditions.checkArgument(!namePart.isEmpty(), "namePart is empty");
        return namePart;
    }

    public AppEngineFile(String fullPath) {
        this(fullPath, null, null);
    }

    private AppEngineFile(String fullPath, FileSystem fileSystem, String namePart) {
        Preconditions.checkNotNull(fullPath, "fullPath");
        fullPath = fullPath.trim();
        Preconditions.checkArgument(!fullPath.isEmpty(), "fullPath is empty");
        this.namePart = namePart;
        this.fullPath = fullPath;
        this.fileSystem = fileSystem;
        if (null == fileSystem || null == namePart) {
            this.parseFullPath();
        }
    }

    private void parseFullPath() {
        Matcher m = fullPathPattern.matcher(this.fullPath);
        if (!m.matches()) {
            throw new IllegalArgumentException(this.fullPath + " is not a valid path");
        }
        String fileSystemString = m.group(1);
        this.fileSystem = FileSystem.fromName(fileSystemString);
        this.namePart = m.group(2);
    }

    public String getNamePart() {
        return this.namePart;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String toString() {
        return this.fullPath;
    }

    BlobKey getCachedBlobKey() {
        return this.cachedBlobKey;
    }

    void setCachedBlobKey(BlobKey key) {
        this.cachedBlobKey = key;
    }

    public boolean isWritable() {
        if (this.fileSystem == FileSystem.GS) {
            return this.namePart.startsWith("writable:");
        }
        return true;
    }

    public boolean isReadable() {
        if (this.fileSystem == FileSystem.GS) {
            return !this.namePart.startsWith("writable:");
        }
        return true;
    }

    public static enum FileSystem {
        BLOBSTORE("blobstore"),
        GS("gs");

        private String name;

        private FileSystem(String fsn) {
            this.name = fsn;
        }

        public String getName() {
            return this.name;
        }

        public static FileSystem fromName(String name) {
            for (FileSystem fs : FileSystem.values()) {
                if (!fs.getName().equals(name)) continue;
                return fs;
            }
            throw new IllegalArgumentException(name + " is not the name of a file system.");
        }
    }
}

