/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class HTTPRequest
implements Serializable {
    private final HTTPMethod method;
    private final URL url;
    private final LinkedHashMap<String, HTTPHeader> headers;
    private final FetchOptions fetchOptions;
    private byte[] payload = null;

    public HTTPRequest(URL url) {
        this(url, HTTPMethod.GET);
    }

    public HTTPRequest(URL url, HTTPMethod method) {
        this(url, method, FetchOptions.Builder.withDefaults());
    }

    public HTTPRequest(URL url, HTTPMethod method, FetchOptions fetchOptions) {
        this.url = url;
        this.method = method;
        this.fetchOptions = fetchOptions;
        this.headers = new LinkedHashMap();
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void addHeader(HTTPHeader header) {
        String name = header.getName();
        HTTPHeader newHeader = this.headers.get(name);
        if (newHeader == null) {
            this.headers.put(name, new HTTPHeader(name, header.getValue()));
        } else {
            this.headers.put(name, new HTTPHeader(name, newHeader.getValue() + ", " + header.getValue()));
        }
    }

    public void setHeader(HTTPHeader header) {
        this.headers.put(header.getName(), header);
    }

    public List<HTTPHeader> getHeaders() {
        return Collections.unmodifiableList(new ArrayList<HTTPHeader>(this.headers.values()));
    }

    public FetchOptions getFetchOptions() {
        return this.fetchOptions;
    }
}

