/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.valuegenerator;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.Utils;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;

public class SequenceGenerator
extends AbstractDatastoreGenerator {
    private static final String SEQUENCE_POSTFIX = "_SEQUENCE__";
    private static final String KEY_CACHE_SIZE_PROPERTY = "key-cache-size";
    private static final ThreadLocal<String> SEQUENCE_POSTFIX_APPENDAGE = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };
    private String sequenceName;

    public SequenceGenerator(String name, Properties props) {
        super(name, props);
    }

    public void setStoreManager(StoreManager storeMgr) {
        super.setStoreManager(storeMgr);
        NucleusContext omfContext = storeMgr.getNucleusContext();
        MetaDataManager mdm = omfContext.getMetaDataManager();
        ClassLoaderResolver clr = omfContext.getClassLoaderResolver(((Object)((Object)this)).getClass().getClassLoader());
        AbstractClassMetaData acmd = mdm.getMetaDataForClass((String)this.properties.get("class-name"), clr);
        if (acmd != null) {
            ((DatastoreManager)storeMgr).validateMetaDataForClass(acmd);
        }
        this.sequenceName = this.determineSequenceName(acmd);
        if (this.sequenceName != null) {
            SequenceMetaData sequenceMetaData = mdm.getMetaDataForSequence(clr, this.sequenceName);
            if (sequenceMetaData != null) {
                this.allocationSize = sequenceMetaData.hasExtension(KEY_CACHE_SIZE_PROPERTY) ? Integer.parseInt(sequenceMetaData.getValueForExtension(KEY_CACHE_SIZE_PROPERTY)) : sequenceMetaData.getAllocationSize();
                this.sequenceName = sequenceMetaData.getDatastoreSequence();
            } else if (this.properties.getProperty(KEY_CACHE_SIZE_PROPERTY) != null) {
                this.allocationSize = Integer.parseInt(this.properties.getProperty(KEY_CACHE_SIZE_PROPERTY));
            }
        }
        if (this.sequenceName == null) {
            this.sequenceName = this.deriveSequenceNameFromClassMetaData(acmd);
        }
    }

    private String determineSequenceName(AbstractClassMetaData acmd) {
        String sequenceName = (String)this.properties.get("sequence-name");
        if (sequenceName != null) {
            return sequenceName;
        }
        if (acmd == null) {
            throw new IllegalStateException("Received a null AbstractClassMetaData and properties did not contain a sequence-name attribute.");
        }
        String fieldName = (String)this.properties.get("field-name");
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(fieldName.substring(fieldName.lastIndexOf(".") + 1));
        return ammd.getSequence() != null ? ammd.getSequence() : ammd.getValueGeneratorName();
    }

    private String deriveSequenceNameFromClassMetaData(AbstractClassMetaData acmd) {
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(((Object)((Object)this)).getClass().getClassLoader());
        return EntityUtils.determineKind(acmd, (DatastoreManager)this.storeMgr, clr) + SEQUENCE_POSTFIX + SEQUENCE_POSTFIX_APPENDAGE.get();
    }

    protected ValueGenerationBlock reserveBlock(long size) {
        if (this.sequenceName == null) {
            throw new IllegalStateException("sequence name is null");
        }
        DatastoreServiceConfig config = ((DatastoreManager)this.storeMgr).getDefaultDatastoreServiceConfigForWrites();
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        KeyRange range = ds.allocateIds(this.sequenceName, size);
        ArrayList<Object> ids = Utils.newArrayList(new Object[0]);
        long current = range.getStart().getId();
        int i = 0;
        while ((long)i < size) {
            ids.add(current + (long)i);
            ++i;
        }
        return new ValueGenerationBlock(ids);
    }

    public static void setSequencePostfixAppendage(String appendage) {
        SEQUENCE_POSTFIX_APPENDAGE.set(appendage);
    }

    public static void clearSequencePostfixAppendage() {
        SEQUENCE_POSTFIX_APPENDAGE.remove();
    }
}

