/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fillCell;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.TiledCell;
import com.sun.electric.tool.generator.layout.fillCell.FillCellGenJob;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TreeTiledCell
extends TiledCell {
    public TreeTiledCell(FillGenConfig conf, EditingPreferences ep) {
        super(conf, ep);
    }

    private static int getFillDimension(int size2, boolean binary) {
        if (size2 <= 2) {
            return size2;
        }
        if (binary) {
            double val = Math.sqrt(size2);
            val = Math.ceil(val);
            return (int)Math.pow(2.0, val);
        }
        if (size2 % 2 != 0) {
            --size2;
        }
        return size2;
    }

    private boolean refine(List<Cell> masters, Rectangle2D masterBnd, Cell empty, Library autoLib, Rectangle2D box, boolean isPlanHorizontal, List<Cell> newElems, Cell topCell, Area area) {
        double[] widths;
        double masterW = masterBnd.getWidth();
        double masterH = masterBnd.getHeight();
        double w = box.getWidth();
        double wHalf = w / 2.0;
        double h = box.getHeight();
        double hHalf = h / 2.0;
        double x = box.getX();
        double y = box.getY();
        double refineOnX = w / masterW;
        double refineOnY = h / masterH;
        if (DBMath.hasRemainder(w, masterW) || DBMath.hasRemainder(h, masterH)) {
            System.out.println("not good refinement");
        }
        if (this.config.job != null && this.config.job.checkAbort()) {
            return false;
        }
        int cutX = (int)Math.ceil(refineOnX);
        int cutY = (int)Math.ceil(refineOnY);
        assert (cutX > 0 && cutY > 0);
        int cutXOnLeft = TreeTiledCell.getFillDimension((int)(refineOnX / 2.0), false);
        int cutXOnRight = cutX - cutXOnLeft;
        int cutYOnBottom = TreeTiledCell.getFillDimension((int)(refineOnY / 2.0), false);
        int cutYOnTop = cutY - cutYOnBottom;
        ArrayList<Cell> childrenList = new ArrayList<Cell>();
        boolean stdCell = true;
        ArrayList<Rectangle2D> boxes = new ArrayList<Rectangle2D>();
        CutType cut = CutType.NONE;
        Rectangle2D bb = null;
        ArrayList<String> namesList = new ArrayList<String>();
        if (cutX > 1 && cutY > 1) {
            cut = CutType.XY;
            widths = null;
            double[] heights = null;
            double[] centerX = null;
            double[] centerY = null;
            if (this.config.binary) {
                widths = new double[]{wHalf, wHalf, wHalf, wHalf};
                heights = new double[]{hHalf, hHalf, hHalf, hHalf};
                centerX = new double[]{box.getCenterX(), box.getCenterX(), box.getCenterX(), box.getCenterX()};
                centerY = new double[]{box.getCenterY(), box.getCenterY(), box.getCenterY(), box.getCenterY()};
            } else {
                double tmpXLeft = (double)cutXOnLeft * masterW;
                double tmpYOnBottom = (double)cutYOnBottom * masterH;
                widths = new double[]{tmpXLeft, (double)cutXOnRight * masterW};
                heights = new double[]{tmpYOnBottom, (double)cutYOnTop * masterH};
                centerX = new double[]{x, x + tmpXLeft};
                centerY = new double[]{y, y + tmpYOnBottom};
            }
            for (int i = 0; i < 4; ++i) {
                int xPos = i % 2;
                int yPos = i / 2;
                bb = GenMath.getQTreeBox(x, y, widths[xPos], heights[yPos], centerX[xPos], centerY[yPos], i);
                boxes.add(bb);
                if (this.refine(masters, masterBnd, empty, autoLib, bb, isPlanHorizontal, childrenList, topCell, area)) continue;
                stdCell = false;
            }
        } else if (cutX > 1) {
            cut = CutType.X;
            widths = null;
            double[] centerX = null;
            if (this.config.binary) {
                widths = new double[]{wHalf, wHalf};
                centerX = new double[]{box.getCenterX(), box.getCenterX()};
            } else {
                double tmpXLeft = (double)cutXOnLeft * masterW;
                widths = new double[]{tmpXLeft, (double)cutXOnRight * masterW};
                centerX = new double[]{x, x + tmpXLeft};
            }
            for (int i = 0; i < 2; ++i) {
                bb = GenMath.getQTreeBox(x, y, widths[i], h, centerX[i], box.getCenterY(), i);
                boxes.add(bb);
                if (this.refine(masters, masterBnd, empty, autoLib, bb, isPlanHorizontal, childrenList, topCell, area)) continue;
                stdCell = false;
            }
        } else if (cutY > 1) {
            cut = CutType.Y;
            double[] heights = null;
            double[] centerY = null;
            if (this.config.binary) {
                heights = new double[]{hHalf, hHalf};
                centerY = new double[]{box.getCenterY(), box.getCenterY()};
            } else {
                double tmpYOnBottom = (double)cutYOnBottom * masterH;
                heights = new double[]{tmpYOnBottom, (double)cutYOnTop * masterH};
                centerY = new double[]{y, y + tmpYOnBottom};
            }
            for (int i = 0; i < 2; ++i) {
                bb = GenMath.getQTreeBox(x, y, w, heights[i], box.getCenterX(), centerY[i], i * 2);
                boxes.add(bb);
                if (this.refine(masters, masterBnd, empty, autoLib, bb, isPlanHorizontal, childrenList, topCell, area)) continue;
                stdCell = false;
            }
        } else {
            if (this.config.job != null && this.config.job.checkAbort()) {
                return false;
            }
            HashSet<NodeInst> nodesToRemove = new HashSet<NodeInst>();
            HashSet<ArcInst> arcsToRemove = new HashSet<ArcInst>();
            boolean excluded = false;
            Cell theMasterCell = null;
            Cell bestFitCell = null;
            int bestFitNum = Integer.MAX_VALUE;
            for (Cell master : masters) {
                Rectangle2D.Double box1 = new Rectangle2D.Double(box.getMinX() + this.config.gap, box.getMinY() + this.config.gap, box.getWidth() - this.config.gap * 2.0, box.getHeight() - this.config.gap * 2.0);
                Rectangle2D essentialBnd = master.findEssentialBounds();
                if (essentialBnd == null) {
                    essentialBnd = master.getBounds();
                }
                ERectangle masterRealBnd = master.getBounds();
                FixpTransform fillTransUp = FixpTransform.getTranslateInstance(box.getCenterX() - ((RectangularShape)masterRealBnd).getCenterX(), box.getCenterY() - ((RectangularShape)masterRealBnd).getCenterY());
                boolean isExcluded = area.intersects(box1);
                Cell c = null;
                if (isExcluded) {
                    theMasterCell = empty;
                    excluded = true;
                    break;
                }
                c = FillCellGenJob.detectOverlappingBars(master, master, empty, fillTransUp, nodesToRemove, arcsToRemove, topCell, new NodeInst[0], this.config.drcSpacingRule, 0);
                if (c != empty && c != null) {
                    theMasterCell = c;
                    break;
                }
                int numToRemove = arcsToRemove.size() + nodesToRemove.size();
                if (c == empty || numToRemove >= bestFitNum) continue;
                bestFitCell = master;
                bestFitNum = numToRemove;
            }
            stdCell = true;
            if (theMasterCell == null) {
                assert (!excluded);
                boolean isEmptyCell = excluded || bestFitCell == null || arcsToRemove.size() == bestFitCell.getNumArcs();
                Cell dummyCell = null;
                if (isEmptyCell) {
                    dummyCell = empty;
                } else {
                    String dummyName = "dummy";
                    namesList.clear();
                    for (NodeInst ni : nodesToRemove) {
                        if (ni.getProto().getFunction().isPin()) continue;
                        namesList.add(ni.getName());
                    }
                    Collections.sort(namesList);
                    int code = ((Object)namesList).toString().hashCode();
                    dummyName = dummyName + code + "{lay}";
                    dummyCell = empty.getLibrary().findNodeProto(dummyName);
                    if (dummyCell == null) {
                        dummyCell = Cell.copyNodeProto(bestFitCell, bestFitCell.getLibrary(), dummyName, true);
                        for (NodeInst ni : nodesToRemove) {
                            NodeInst d = dummyCell.findNode(ni.getName());
                            if (d == null) continue;
                            d.kill();
                        }
                        for (ArcInst ai : arcsToRemove) {
                            ArcInst d = dummyCell.findArc(ai.getName());
                            if (d == null) continue;
                            d.kill();
                        }
                        if (dummyCell.getNumArcs() == 0) {
                            dummyCell.kill();
                            dummyCell = empty;
                            isEmptyCell = true;
                        }
                    }
                }
                newElems.add(dummyCell);
                stdCell = isEmptyCell;
            } else {
                newElems.add(theMasterCell);
            }
            return stdCell;
        }
        if (this.config.job != null && this.config.job.checkAbort()) {
            return false;
        }
        Cell tiledCell = null;
        String tileName = null;
        boolean stdC = true;
        boolean readStdC = true;
        assert (childrenList.size() > 1);
        Cell template = (Cell)childrenList.get(0);
        for (int i = 1; i < childrenList.size(); ++i) {
            if (template == childrenList.get(i)) continue;
            stdC = false;
            readStdC = false;
            break;
        }
        if (!(stdCell = readStdC)) {
            stdCell = stdC;
        }
        stdC = stdCell;
        if (stdCell) {
            String rootName = ((Cell)childrenList.get(0)).getName();
            if (childrenList.get(0) == masters.get(0)) {
                rootName = masters.get(0).getName();
            } else if (childrenList.get(0) == empty) {
                rootName = empty.getName();
            }
            tileName = rootName + "_" + w + "x" + h + "{lay}";
            tiledCell = empty.getLibrary().findNodeProto(tileName);
        } else {
            namesList.clear();
            for (Cell c : childrenList) {
                namesList.add(c.getName());
            }
            namesList.add(cut.toString());
            int code = ((Object)namesList).toString().hashCode();
            tileName = "dummy" + masters.get(0).getName() + "_" + w + "x" + h + "(" + code + "){lay}";
            tiledCell = empty.getLibrary().findNodeProto(tileName);
            if (tiledCell != null) {
                stdC = true;
            }
        }
        if (tiledCell == null || !stdC) {
            tiledCell = Cell.newInstance(empty.getLibrary(), tileName);
            TechType techType = this.config.getTechType();
            LayoutLib.newNodeInst(techType.essentialBounds(), this.ep, -w / 2.0, -h / 2.0, G.DEF_SIZE, G.DEF_SIZE, 180.0, tiledCell);
            LayoutLib.newNodeInst(techType.essentialBounds(), this.ep, w / 2.0, h / 2.0, G.DEF_SIZE, G.DEF_SIZE, 0.0, tiledCell);
            NodeInst[][] rows = null;
            switch (cut) {
                case X: {
                    rows = new NodeInst[1][2];
                    break;
                }
                case Y: {
                    rows = new NodeInst[2][1];
                    break;
                }
                case XY: {
                    rows = new NodeInst[2][2];
                }
            }
            assert (boxes.size() == childrenList.size());
            block19: for (int i = 0; i < boxes.size(); ++i) {
                Rectangle2D b = (Rectangle2D)boxes.get(i);
                double cenX = b.getCenterX() - box.getCenterX();
                double cenY = b.getCenterY() - box.getCenterY();
                NodeInst node = LayoutLib.newNodeInst((NodeProto)childrenList.get(i), this.ep, cenX, cenY, b.getWidth(), b.getHeight(), 0.0, tiledCell);
                switch (cut) {
                    case X: {
                        rows[0][i] = node;
                        continue block19;
                    }
                    case Y: {
                        rows[i][0] = node;
                        continue block19;
                    }
                    case XY: {
                        rows[i / 2][i % 2] = node;
                    }
                }
            }
            TreeTiledCell.connectAllPortInsts(this.config.getTechType(), this.ep, tiledCell);
            this.exportUnconnectedPortInsts(rows, isPlanHorizontal, tiledCell);
        }
        newElems.add(tiledCell);
        return stdCell;
    }

    public Cell makeQTreeCell(List<Cell> masters, Cell empty, Library autoLib, int tileOnX, int tileOnY, boolean isPlanHorizontal, Cell topCell, List<Rectangle2D> topBoxList, Area area) {
        double fillWidth = (double)tileOnX * this.config.minTileSizeX;
        double fillHeight = (double)tileOnY * this.config.minTileSizeY;
        if (this.config.binary) {
            int powerX = TreeTiledCell.getFillDimension(tileOnX, true);
            int powerY = TreeTiledCell.getFillDimension(tileOnY, true);
            fillWidth = (double)powerX * this.config.minTileSizeX;
            fillHeight = (double)powerY * this.config.minTileSizeY;
        }
        Rectangle2D topEssential = topCell.findEssentialBounds();
        Rectangle2D.Double topBox = new Rectangle2D.Double(topCell.getBounds().getX() + this.config.gap, topCell.getBounds().getY() + this.config.gap, fillWidth, fillHeight);
        if (topEssential != null) {
            topBox = new Rectangle2D.Double(topEssential.getX(), topEssential.getY(), fillWidth, fillHeight);
        }
        topBoxList.clear();
        topBoxList.add(topBox);
        ArrayList<Cell> newElems = new ArrayList<Cell>();
        Rectangle2D essentialBnd = masters.get(0).findEssentialBounds();
        if (essentialBnd == null) {
            essentialBnd = masters.get(0).getBounds();
        }
        this.refine(masters, essentialBnd, empty, autoLib, topBox, isPlanHorizontal, newElems, topCell, area);
        assert (newElems.size() == 1);
        return (Cell)newElems.iterator().next();
    }

    static enum CutType {
        NONE,
        X,
        Y,
        XY;

    }
}

