/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellRevisionJ;
import com.sun.electric.database.CellRevisionProvider;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import java.util.Arrays;
import java.util.Iterator;

public class CellRevisionProviderDefault
extends CellRevisionProvider {
    private static final ImmutableNodeInstIterable emptyNodeList = new ImmutableNodeInstIterable(ImmutableNodeInst.NULL_ARRAY, null);
    private static final ImmutableArcInstIterable emptyArcList = new ImmutableArcInstIterable(ImmutableArcInst.NULL_ARRAY);
    private static final ImmutableExportIterable emptyExportList = new ImmutableExportIterable(ImmutableExport.NULL_ARRAY);

    @Override
    public CellRevision createCellRevision(ImmutableCell c) {
        return new CellRevisionJ(c);
    }

    @Override
    protected ImmutableNodeInst.Iterable createNodeList(ImmutableNodeInst[] elems, ImmutableNodeInst.Iterable oldList) {
        if (elems != null) {
            if (elems.length == 0) {
                return emptyNodeList;
            }
            if (oldList == null) {
                oldList = emptyNodeList;
            }
            Iterator<ImmutableNodeInst> it = oldList.iterator();
            boolean changed = false;
            int i = 0;
            while (it.hasNext() && i < elems.length) {
                ImmutableNodeInst on = it.next();
                if (elems[i] == on) {
                    ++i;
                    continue;
                }
                changed = true;
                String ons = on.name.toString();
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(elems[i].name.toString(), ons);
                while (cmp < 0) {
                    if (i > 0 && TextUtils.STRING_NUMBER_ORDER.compare(elems[i - 1].name.toString(), elems[i].name.toString()) >= 0) {
                        throw new IllegalArgumentException("nodes order");
                    }
                    cmp = ++i == elems.length ? 1 : TextUtils.STRING_NUMBER_ORDER.compare(elems[i].name.toString(), ons);
                }
                if (cmp != 0) continue;
                ++i;
            }
            while (i < elems.length) {
                changed = true;
                if (i > 0 && TextUtils.STRING_NUMBER_ORDER.compare(elems[i - 1].name.toString(), elems[i].name.toString()) >= 0) {
                    throw new IllegalArgumentException("nodes order");
                }
                ++i;
            }
            if (it.hasNext()) {
                changed = true;
            }
            if (!changed) {
                return oldList;
            }
            ImmutableNodeInstIterable old = (ImmutableNodeInstIterable)oldList;
            int[] nodeIndex = old.nodeIndex;
            boolean sameNodeIdAndIndex = true;
            boolean sameNodeIndex = elems.length == old.size();
            int nodeIndexLength = 0;
            int nodeInd = 0;
            Iterator<ImmutableNodeInst> oldNodes = old.iterator();
            for (ImmutableNodeInst n : elems) {
                sameNodeIdAndIndex = sameNodeIdAndIndex && n.nodeId == nodeInd;
                sameNodeIndex = sameNodeIndex && n.nodeId == oldNodes.next().nodeId;
                nodeIndexLength = Math.max(nodeIndexLength, n.nodeId + 1);
                ++nodeInd;
            }
            if (sameNodeIdAndIndex) {
                nodeIndex = null;
            } else if (!sameNodeIndex) {
                nodeIndex = new int[nodeIndexLength];
                Arrays.fill(nodeIndex, -1);
                nodeInd = 0;
                for (ImmutableNodeInst n : elems) {
                    int nodeId = n.nodeId;
                    if (nodeIndex[nodeId] >= 0) {
                        throw new IllegalArgumentException("nodeChronIndex");
                    }
                    nodeIndex[nodeId] = nodeInd++;
                }
                assert (!Arrays.equals(old.nodeIndex, nodeIndex));
            }
            return new ImmutableNodeInstIterable(elems, nodeIndex);
        }
        return oldList != null ? oldList : emptyNodeList;
    }

    @Override
    protected ImmutableArcInst.Iterable createArcList(ImmutableArcInst[] elems, ImmutableArcInst.Iterable oldList) {
        if (elems != null) {
            return elems.length != 0 ? new ImmutableArcInstIterable(elems) : emptyArcList;
        }
        return oldList != null ? oldList : emptyArcList;
    }

    @Override
    protected ImmutableExport.Iterable createExportList(ImmutableExport[] elems, ImmutableExport.Iterable oldList) {
        if (elems != null) {
            return elems.length != 0 ? new ImmutableExportIterable(elems) : emptyExportList;
        }
        return oldList != null ? oldList : emptyExportList;
    }

    public static class ImmutableExportIterable
    implements ImmutableExport.Iterable {
        private final ImmutableExport[] elems;

        ImmutableExportIterable(ImmutableExport[] elems) {
            this.elems = elems;
            ImmutableExport prevE = null;
            for (ImmutableExport e : this.elems) {
                if (prevE != null && TextUtils.STRING_NUMBER_ORDER.compare(prevE.name.toString(), e.name.toString()) >= 0) {
                    throw new IllegalArgumentException("exports order");
                }
                prevE = e;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableExport get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableExport> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableExport e = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(e.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }

        @Override
        public ImmutableExport[] toArray() {
            return (ImmutableExport[])this.elems.clone();
        }
    }

    public static class ImmutableArcInstIterable
    implements ImmutableArcInst.Iterable {
        private final ImmutableArcInst[] elems;

        ImmutableArcInstIterable(ImmutableArcInst[] elems) {
            this.elems = elems;
            ImmutableArcInst prevA = null;
            for (ImmutableArcInst a : this.elems) {
                int cmp;
                if (prevA != null && ((cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevA.name.toString(), a.name.toString())) > 0 || cmp == 0 && (a.name.isTempname() || prevA.arcId >= a.arcId))) {
                    throw new IllegalArgumentException("arcs order " + a.name);
                }
                prevA = a;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableArcInst get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableArcInst> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableArcInst a = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(a.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }
    }

    public static class ImmutableNodeInstIterable
    implements ImmutableNodeInst.Iterable {
        private final ImmutableNodeInst[] elems;
        private final int[] nodeIndex;

        ImmutableNodeInstIterable(ImmutableNodeInst[] elems, int[] nodeIndex) {
            this.elems = elems;
            this.nodeIndex = nodeIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableNodeInst get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableNodeInst> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableNodeInst n = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(n.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }

        @Override
        public ImmutableNodeInst getNodeById(int nodeId) {
            if (this.nodeIndex == null) {
                return nodeId < this.size() ? this.get(nodeId) : null;
            }
            if (nodeId >= this.nodeIndex.length) {
                return null;
            }
            int nodeInd = this.nodeIndex[nodeId];
            return nodeInd >= 0 ? this.get(nodeInd) : null;
        }

        @Override
        public int getNodeIndexByNodeId(int nodeId) {
            int nodeInd;
            int n = nodeInd = this.nodeIndex != null ? this.nodeIndex[nodeId] : nodeId;
            assert (0 <= nodeInd && nodeInd < this.size());
            return nodeInd;
        }

        @Override
        public boolean hasNodeWithId(int nodeId) {
            if (nodeId < 0) {
                throw new IllegalArgumentException();
            }
            if (this.nodeIndex != null) {
                return nodeId < this.nodeIndex.length && this.nodeIndex[nodeId] >= 0;
            }
            return nodeId < this.size();
        }

        @Override
        public int getMaxNodeId() {
            return (this.nodeIndex != null ? this.nodeIndex.length : this.size()) - 1;
        }

        @Override
        public void check() {
            ImmutableNodeInst prevN = null;
            for (ImmutableNodeInst n : this) {
                n.check();
                if (prevN != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevN.name.toString(), n.name.toString()) < 0);
                prevN = n;
            }
            if (this.nodeIndex != null && this.nodeIndex.length > 0) {
                assert (this.nodeIndex[this.nodeIndex.length - 1] >= 0);
                for (int nodeId = 0; nodeId < this.nodeIndex.length; ++nodeId) {
                    int nodeInd = this.nodeIndex[nodeId];
                    if (nodeInd != -1) assert (this.get((int)nodeInd).nodeId == nodeId);
                }
            }
            int nodeInd = 0;
            for (ImmutableNodeInst n : this) {
                assert (this.nodeIndex == null ? n.nodeId == nodeInd : this.nodeIndex[n.nodeId] == nodeInd);
                assert (this.getNodeById(n.nodeId) == n);
                ++nodeInd;
            }
        }
    }
}

