/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactfx.util.Either;

class Right<L, R>
implements Either<L, R> {
    private final R value;

    public Right(R value) {
        this.value = value;
    }

    @Override
    public boolean isLeft() {
        return false;
    }

    @Override
    public boolean isRight() {
        return true;
    }

    @Override
    public L getLeft() {
        throw new NoSuchElementException();
    }

    @Override
    public R getRight() {
        return this.value;
    }

    @Override
    public L toLeft(Function<? super R, ? extends L> f) {
        return f.apply(this.value);
    }

    @Override
    public R toRight(Function<? super L, ? extends R> f) {
        return this.value;
    }

    @Override
    public Optional<L> asLeft() {
        return Optional.empty();
    }

    @Override
    public Optional<R> asRight() {
        return Optional.of(this.value);
    }

    @Override
    public void ifLeft(Consumer<? super L> f) {
    }

    @Override
    public void ifRight(Consumer<? super R> f) {
        f.accept(this.value);
    }

    @Override
    public void exec(Consumer<? super L> ifLeft, Consumer<? super R> ifRight) {
        ifRight.accept(this.value);
    }

    @Override
    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> f) {
        return new Right<L, R>(this.value);
    }

    @Override
    public <R2> Either<L, R2> mapRight(Function<? super R, ? extends R2> f) {
        return new Right<L, R2>(f.apply(this.value));
    }

    @Override
    public <L2, R2> Either<L2, R2> map(Function<? super L, ? extends L2> f, Function<? super R, ? extends R2> g2) {
        return new Right<L, R2>(g2.apply(this.value));
    }

    @Override
    public <L2, R2> Either<L2, R2> flatMap(Function<? super L, Either<L2, R2>> f, Function<? super R, Either<L2, R2>> g2) {
        return g2.apply(this.value);
    }

    @Override
    public <L2> Either<L2, R> flatMapLeft(Function<? super L, Either<L2, R>> f) {
        return new Right<L, R>(this.value);
    }

    @Override
    public <R2> Either<L, R2> flatMapRight(Function<? super R, Either<L, R2>> f) {
        return f.apply(this.value);
    }

    @Override
    public <T> T unify(Function<? super L, ? extends T> f, Function<? super R, ? extends T> g2) {
        return g2.apply(this.value);
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final boolean equals(Object other) {
        if (other instanceof Right) {
            Right that = (Right)other;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return "right(" + this.value + ")";
    }
}

