/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.ArrayList;
import java.util.List;
import org.jabref.model.entry.LinkedFile;

public class FileFieldParser {
    public static List<LinkedFile> parse(String value) {
        ArrayList<LinkedFile> files = new ArrayList<LinkedFile>();
        if (value == null || value.trim().isEmpty()) {
            return files;
        }
        ArrayList<String> entry = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inXmlChar = false;
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == '&' && !inXmlChar) {
                sb.append(c);
                if (value.length() > i + 1 && value.charAt(i + 1) == '#') {
                    inXmlChar = true;
                }
            } else if (!escaped && inXmlChar && c == ';') {
                sb.append(c);
                inXmlChar = false;
            } else if (!escaped && c == ':') {
                entry.add(sb.toString());
                sb = new StringBuilder();
            } else if (!escaped && c == ';' && !inXmlChar) {
                entry.add(sb.toString());
                sb = new StringBuilder();
                files.add(FileFieldParser.convert(entry));
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            entry.add(sb.toString());
        }
        if (!entry.isEmpty()) {
            files.add(FileFieldParser.convert(entry));
        }
        return files;
    }

    private static LinkedFile convert(List<String> entry) {
        while (entry.size() < 3) {
            entry.add("");
        }
        LinkedFile field2 = new LinkedFile(entry.get(0), entry.get(1), entry.get(2));
        if (field2.getDescription().isEmpty() && field2.getLink().isEmpty() && !field2.getFileType().isEmpty()) {
            field2 = new LinkedFile("", field2.getFileType(), "");
        } else if (!field2.getDescription().isEmpty() && field2.getLink().isEmpty() && field2.getFileType().isEmpty()) {
            field2 = new LinkedFile("", field2.getDescription(), "");
        }
        entry.clear();
        return field2;
    }
}

