/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.logic.bibtexkeypattern.BracketedPattern;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;

class RegExpBasedFileFinder
implements FileFinder {
    private static final String EXT_MARKER = "__EXTENSION__";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([^\\\\])\\\\([^\\\\])");
    private static final Pattern SQUARE_BRACKETS_PATTERN = Pattern.compile("\\[.*?\\]");
    private final String regExp;
    private final Character keywordDelimiter;

    RegExpBasedFileFinder(String regExp, Character keywordDelimiter) {
        this.regExp = regExp;
        this.keywordDelimiter = keywordDelimiter;
    }

    public static String expandBrackets(String bracketString, BibEntry entry, BibDatabase database, Character keywordDelimiter) {
        Matcher matcher = SQUARE_BRACKETS_PATTERN.matcher(bracketString);
        StringBuffer expandedStringBuffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = BracketedPattern.expandBrackets(matcher.group(), keywordDelimiter, entry, database);
            matcher.appendReplacement(expandedStringBuffer, replacement);
        }
        matcher.appendTail(expandedStringBuffer);
        return expandedStringBuffer.toString();
    }

    @Override
    public List<Path> findAssociatedFiles(BibEntry entry, List<Path> directories, List<String> extensions) throws IOException {
        String extensionRegExp = '(' + String.join((CharSequence)"|", extensions) + ')';
        return this.findFile(entry, directories, extensionRegExp);
    }

    private List<Path> findFile(BibEntry entry, List<Path> dirs, String extensionRegExp) throws IOException {
        ArrayList<Path> res = new ArrayList<Path>();
        for (Path directory : dirs) {
            res.addAll(this.findFile(entry, directory, this.regExp, extensionRegExp));
        }
        return res;
    }

    private List<Path> findFile(BibEntry entry, Path directory, String file, String extensionRegExp) throws IOException {
        Path actualDirectory;
        ArrayList<Path> resultFiles = new ArrayList<Path>();
        String fileName = file;
        if (fileName.startsWith("/")) {
            actualDirectory = Paths.get(".", new String[0]);
            fileName = fileName.substring(1);
        } else {
            actualDirectory = directory;
        }
        Matcher m3 = ESCAPE_PATTERN.matcher(fileName);
        StringBuffer s2 = new StringBuffer();
        while (m3.find()) {
            m3.appendReplacement(s2, m3.group(1) + '/' + m3.group(2));
        }
        m3.appendTail(s2);
        fileName = s2.toString();
        String[] fileParts = fileName.split("/");
        if (fileParts.length == 0) {
            return resultFiles;
        }
        for (int index = 0; index < fileParts.length - 1; ++index) {
            File[] subDirs;
            String dirToProcess = fileParts[index];
            if ((dirToProcess = RegExpBasedFileFinder.expandBrackets(dirToProcess, entry, null, this.keywordDelimiter)).matches("^.:$")) {
                actualDirectory = Paths.get(dirToProcess + '/', new String[0]);
                continue;
            }
            if (".".equals(dirToProcess)) continue;
            if ("..".equals(dirToProcess)) {
                actualDirectory = actualDirectory.getParent();
                continue;
            }
            if ("*".equals(dirToProcess) && (subDirs = actualDirectory.toFile().listFiles()) != null) {
                String restOfFileString = StringUtil.join(fileParts, "/", index + 1, fileParts.length);
                for (File subDir : subDirs) {
                    if (!subDir.isDirectory()) continue;
                    resultFiles.addAll(this.findFile(entry, subDir.toPath(), restOfFileString, extensionRegExp));
                }
            }
            if (!"**".equals(dirToProcess)) continue;
            String restOfFileString = StringUtil.join(fileParts, "/", index + 1, fileParts.length);
            Path rootDirectory = actualDirectory;
            try (Stream<Path> pathStream = Files.walk(actualDirectory, new FileVisitOption[0]);){
                for (Path path2 : pathStream.filter(element -> this.isSubDirectory(rootDirectory, (Path)element)).collect(Collectors.toList())) {
                    resultFiles.addAll(this.findFile(entry, path2, restOfFileString, extensionRegExp));
                }
                continue;
            }
            catch (UncheckedIOException ioe) {
                throw new IOException(ioe);
            }
        }
        String filePart = fileParts[fileParts.length - 1].replace("[extension]", EXT_MARKER);
        String filenameToLookFor = RegExpBasedFileFinder.expandBrackets(filePart, entry, null, this.keywordDelimiter).replaceAll(EXT_MARKER, extensionRegExp);
        try {
            Pattern toMatch = Pattern.compile('^' + filenameToLookFor.replaceAll("\\\\\\\\", "\\\\") + '$', 2);
            BiPredicate<Path, BasicFileAttributes> matcher = (path, attributes) -> toMatch.matcher(path.getFileName().toString()).matches();
            resultFiles.addAll(this.collectFilesWithMatcher(actualDirectory, matcher));
        }
        catch (UncheckedIOException | PatternSyntaxException e) {
            throw new IOException("Could not look for " + filenameToLookFor, e);
        }
        return resultFiles;
    }

    private List<Path> collectFilesWithMatcher(Path actualDirectory, BiPredicate<Path, BasicFileAttributes> matcher) {
        List<Path> list;
        block8: {
            Stream<Path> pathStream = Files.find(actualDirectory, 1, matcher, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                list = pathStream.collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (pathStream != null) {
                            RegExpBasedFileFinder.$closeResource(throwable, pathStream);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | UncheckedIOException ioe) {
                    return Collections.emptyList();
                }
            }
            RegExpBasedFileFinder.$closeResource(throwable, pathStream);
        }
        return list;
    }

    private boolean isSubDirectory(Path rootDirectory, Path path) {
        return !rootDirectory.equals(path) && Files.isDirectory(path, new LinkOption[0]);
    }
}

