/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.Scanner;
import java.util.regex.Pattern;

public class JavaVersion {
    private static final Pattern DELIMITER = Pattern.compile("[._\\-+]");
    private final String JAVA_VERSION;

    public JavaVersion() {
        this.JAVA_VERSION = System.getProperty("java.version");
    }

    public JavaVersion(String version) {
        this.JAVA_VERSION = version;
    }

    public boolean isJava9() {
        if (this.JAVA_VERSION != null) {
            Scanner scanner = new Scanner(this.JAVA_VERSION);
            scanner.useDelimiter(DELIMITER);
            if (scanner.hasNextInt()) {
                return this.isAtLeast("1.9");
            }
        }
        return false;
    }

    public boolean isAtLeast(String version) {
        if (this.JAVA_VERSION == null || version == null) {
            return true;
        }
        Scanner scannerRunningVersion = new Scanner(this.JAVA_VERSION);
        Scanner scannerRequiredVersion = new Scanner(version);
        scannerRunningVersion.useDelimiter(DELIMITER);
        scannerRequiredVersion.useDelimiter(DELIMITER);
        while (scannerRunningVersion.hasNextInt() && scannerRequiredVersion.hasNextInt()) {
            int required;
            int running = scannerRunningVersion.nextInt();
            if (running == (required = scannerRequiredVersion.nextInt())) continue;
            return running >= required;
        }
        return true;
    }

    public String getJavaVersion() {
        return this.JAVA_VERSION;
    }

    public String getJavaInstallationDirectory() {
        return System.getProperty("java.home");
    }
}

