/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;

public class EntryLinkChecker
implements IntegrityCheck.Checker {
    private final BibDatabase database;

    public EntryLinkChecker(BibDatabase database) {
        this.database = Objects.requireNonNull(database);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field2 : entry.getFieldMap().entrySet()) {
            Set<FieldProperty> properties = InternalBibtexFields.getFieldProperties(field2.getKey());
            if (properties.contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
                if (this.database.getEntryByKey(field2.getValue()).isPresent()) continue;
                result.add(new IntegrityMessage(Localization.lang("Referenced BibTeX key does not exist", new String[0]), entry, field2.getKey()));
                continue;
            }
            if (!properties.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) continue;
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(field2.getValue().split(",")));
            for (String key : keys) {
                if (this.database.getEntryByKey(key).isPresent()) continue;
                result.add(new IntegrityMessage(Localization.lang("Referenced BibTeX key does not exist", new String[0]) + ": " + key, entry, field2.getKey()));
            }
        }
        return result;
    }
}

