/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.bibtex.comparator.FieldComparatorStack;
import org.jabref.logic.layout.format.GetOpenOfficeType;
import org.jabref.logic.layout.format.RemoveBrackets;
import org.jabref.logic.layout.format.RemoveWhitespace;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class OOCalcDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OOCalcDatabase.class);
    private final List<BibEntry> entries;

    public OOCalcDatabase(BibDatabase bibtex, List<BibEntry> entries) {
        ArrayList<FieldComparator> comparators = new ArrayList<FieldComparator>();
        comparators.add(new FieldComparator("author"));
        comparators.add(new FieldComparator("year"));
        comparators.add(new FieldComparator("bibtexkey"));
        ArrayList<BibEntry> entryList = new ArrayList<BibEntry>();
        if (entries == null) {
            entryList.addAll((Collection<BibEntry>)bibtex.getEntries());
        } else {
            entryList.addAll(entries);
        }
        Collections.sort(entryList, new FieldComparatorStack(comparators));
        this.entries = entryList;
    }

    public Document getDOMrepresentation() {
        Document result = null;
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = dbuild.newDocument();
            Element collection = result.createElement("office:document-content");
            collection.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
            collection.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
            collection.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
            collection.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
            collection.setAttribute("xmlns:office:class", "spreadsheet");
            collection.setAttribute("xmlns:office:version", "1.0");
            collection.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
            Element el = result.createElement("office:script");
            collection.appendChild(el);
            el = result.createElement("office:automatic-styles");
            Element el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ro1");
            el2.setAttribute("style:family", "table-row");
            Element el3 = result.createElement("style.properties");
            el3.setAttribute("style:row-height", "0.1681inch");
            el3.setAttribute("fo:break-before", "auto");
            el3.setAttribute("style:use-optimal-row-height", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ta1");
            el2.setAttribute("style:family", "table");
            el2.setAttribute("style:master-page-name", "Default");
            el3 = result.createElement("style:properties");
            el3.setAttribute("table:display", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            collection.appendChild(el);
            Element body = result.createElement("office:body");
            Element table = result.createElement("table:table");
            table.setAttribute("table:name", "biblio");
            table.setAttribute("table.style-name", "ta1");
            Element row = result.createElement("table:table-row");
            row.setAttribute("table.style-name", "ro1");
            OOCalcDatabase.addTableCell(result, row, "Type");
            OOCalcDatabase.addTableCell(result, row, "ISBN");
            OOCalcDatabase.addTableCell(result, row, "Identifier");
            OOCalcDatabase.addTableCell(result, row, "Author");
            OOCalcDatabase.addTableCell(result, row, "Title");
            OOCalcDatabase.addTableCell(result, row, "Journal");
            OOCalcDatabase.addTableCell(result, row, "Volume");
            OOCalcDatabase.addTableCell(result, row, "Number");
            OOCalcDatabase.addTableCell(result, row, "Month");
            OOCalcDatabase.addTableCell(result, row, "Pages");
            OOCalcDatabase.addTableCell(result, row, "Year");
            OOCalcDatabase.addTableCell(result, row, "Address");
            OOCalcDatabase.addTableCell(result, row, "Note");
            OOCalcDatabase.addTableCell(result, row, "URL");
            OOCalcDatabase.addTableCell(result, row, "Booktitle");
            OOCalcDatabase.addTableCell(result, row, "Chapter");
            OOCalcDatabase.addTableCell(result, row, "Edition");
            OOCalcDatabase.addTableCell(result, row, "Series");
            OOCalcDatabase.addTableCell(result, row, "Editor");
            OOCalcDatabase.addTableCell(result, row, "Publisher");
            OOCalcDatabase.addTableCell(result, row, "ReportType");
            OOCalcDatabase.addTableCell(result, row, "Howpublished");
            OOCalcDatabase.addTableCell(result, row, "Institution");
            OOCalcDatabase.addTableCell(result, row, "Organization");
            OOCalcDatabase.addTableCell(result, row, "School");
            OOCalcDatabase.addTableCell(result, row, "Annote");
            OOCalcDatabase.addTableCell(result, row, "Assignee");
            OOCalcDatabase.addTableCell(result, row, "Day");
            OOCalcDatabase.addTableCell(result, row, "Dayfiled");
            OOCalcDatabase.addTableCell(result, row, "Monthfiled");
            OOCalcDatabase.addTableCell(result, row, "Yearfiled");
            OOCalcDatabase.addTableCell(result, row, "Language");
            OOCalcDatabase.addTableCell(result, row, "Nationality");
            OOCalcDatabase.addTableCell(result, row, "Revision");
            OOCalcDatabase.addTableCell(result, row, "Custom1");
            OOCalcDatabase.addTableCell(result, row, "Custom2");
            OOCalcDatabase.addTableCell(result, row, "Custom3");
            OOCalcDatabase.addTableCell(result, row, "Custom4");
            OOCalcDatabase.addTableCell(result, row, "Custom5");
            table.appendChild(row);
            for (BibEntry e : this.entries) {
                row = result.createElement("table:table-row");
                OOCalcDatabase.addTableCell(result, row, new GetOpenOfficeType().format(e.getType()));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "isbn"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "bibtexkey"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "author"));
                OOCalcDatabase.addTableCell(result, row, new RemoveWhitespace().format(new RemoveBrackets().format(OOCalcDatabase.getField(e, "title"))));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "journal"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "volume"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "number"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "month"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "pages"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "year"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "address"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "note"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "url"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "booktitle"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "chapter"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "edition"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "series"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "editor"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "publisher"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "reporttype"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "howpublished"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "institution"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "organization"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "school"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "annote"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "assignee"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "day"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "dayfiled"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "monthfiled"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "yearfiled"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "language"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "nationality"));
                OOCalcDatabase.addTableCell(result, row, OOCalcDatabase.getField(e, "revision"));
                OOCalcDatabase.addTableCell(result, row, "");
                OOCalcDatabase.addTableCell(result, row, "");
                OOCalcDatabase.addTableCell(result, row, "");
                OOCalcDatabase.addTableCell(result, row, "");
                OOCalcDatabase.addTableCell(result, row, "");
                table.appendChild(row);
            }
            body.appendChild(table);
            collection.appendChild(body);
            result.appendChild(collection);
        }
        catch (Exception e) {
            LOGGER.warn("Exception caught...", e);
        }
        return result;
    }

    private static String getField(BibEntry e, String field2) {
        return e.getField(field2).orElse("");
    }

    private static void addTableCell(Document doc, Element parent, String content) {
        Element cell = doc.createElement("table:table-cell");
        Element text = doc.createElement("text:p");
        Text textNode = doc.createTextNode(content);
        text.appendChild(textNode);
        cell.appendChild(text);
        parent.appendChild(cell);
    }
}

