/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javax.inject.Inject;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;
import org.fxmisc.easybind.EasyBind;
import org.jabref.Globals;
import org.jabref.gui.AbstractController;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.StateManager;
import org.jabref.gui.groups.DroppingMouseLocation;
import org.jabref.gui.groups.GroupNodeViewModel;
import org.jabref.gui.groups.GroupTreeViewModel;
import org.jabref.gui.groups.TransferableEntrySelection;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelTreeTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.AllEntriesGroup;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTreeController
extends AbstractController<GroupTreeViewModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupTreeController.class);
    @FXML
    private TreeTableView<GroupNodeViewModel> groupTree;
    @FXML
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> mainColumn;
    @FXML
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> numberColumn;
    @FXML
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> disclosureNodeColumn;
    @FXML
    private CustomTextField searchField;
    @Inject
    private StateManager stateManager;
    @Inject
    private DialogService dialogService;
    @Inject
    private TaskExecutor taskExecutor;

    private static void removePseudoClasses(TreeTableRow<GroupNodeViewModel> row, PseudoClass ... pseudoClasses) {
        for (PseudoClass pseudoClass : pseudoClasses) {
            row.pseudoClassStateChanged(pseudoClass, false);
        }
    }

    @FXML
    public void initialize() {
        this.viewModel = new GroupTreeViewModel(this.stateManager, this.dialogService, this.taskExecutor);
        this.groupTree.setStyle("-fx-font-size: " + Globals.prefs.getFontSizeFX() + "pt;");
        this.groupTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Consumer updateSelectedGroups = newSelectedGroups -> newSelectedGroups.forEach(this::selectNode);
        BindingsHelper.bindContentBidirectional(this.groupTree.getSelectionModel().getSelectedItems(), ((GroupTreeViewModel)this.viewModel).selectedGroupsProperty(), updateSelectedGroups, this::updateSelection);
        Timer searchTask = FxTimer.create(Duration.ofMillis(400L), () -> {
            LOGGER.debug("Run group search " + this.searchField.getText());
            ((GroupTreeViewModel)this.viewModel).filterTextProperty().setValue(this.searchField.textProperty().getValue());
        });
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> searchTask.restart());
        this.groupTree.rootProperty().bind(EasyBind.map(((GroupTreeViewModel)this.viewModel).rootGroupProperty(), group -> new RecursiveTreeItem<GroupNodeViewModel>((GroupNodeViewModel)group, (Callback<GroupNodeViewModel, ObservableList<GroupNodeViewModel>>)((Callback)GroupNodeViewModel::getChildren), (Callback<GroupNodeViewModel, BooleanProperty>)((Callback)GroupNodeViewModel::expandedProperty), (ObservableValue<Predicate<GroupNodeViewModel>>)((GroupTreeViewModel)this.viewModel).filterPredicateProperty())));
        this.mainColumn.setCellValueFactory(cellData -> cellData.getValue().valueProperty());
        this.mainColumn.setCellFactory(new ViewModelTreeTableCellFactory().withText(GroupNodeViewModel::getDisplayName).withIcon(GroupNodeViewModel::getIcon, GroupNodeViewModel::getColor).withTooltip(GroupNodeViewModel::getDescription));
        PseudoClass anySelected = PseudoClass.getPseudoClass((String)"any-selected");
        PseudoClass allSelected = PseudoClass.getPseudoClass((String)"all-selected");
        this.numberColumn.setCellFactory(new ViewModelTreeTableCellFactory().withGraphic(group -> {
            StackPane node = new StackPane();
            node.getStyleClass().setAll((Object[])new String[]{"hits"});
            if (!group.isRoot()) {
                BindingsHelper.includePseudoClassWhen((Node)node, anySelected, (ObservableValue<? extends Boolean>)group.anySelectedEntriesMatchedProperty());
                BindingsHelper.includePseudoClassWhen((Node)node, allSelected, (ObservableValue<? extends Boolean>)group.allSelectedEntriesMatchedProperty());
            }
            Text text = new Text();
            text.textProperty().bind((ObservableValue)group.getHits().asString());
            text.getStyleClass().setAll((Object[])new String[]{"text"});
            node.getChildren().add((Object)text);
            node.setMaxWidth(Double.NEGATIVE_INFINITY);
            return node;
        }));
        this.disclosureNodeColumn.setCellValueFactory(cellData -> cellData.getValue().valueProperty());
        this.disclosureNodeColumn.setCellFactory(new ViewModelTreeTableCellFactory().withGraphic(viewModel -> {
            StackPane disclosureNode = new StackPane();
            disclosureNode.visibleProperty().bind((ObservableValue)viewModel.hasChildrenProperty());
            disclosureNode.getStyleClass().setAll((Object[])new String[]{"tree-disclosure-node"});
            StackPane disclosureNodeArrow = new StackPane();
            disclosureNodeArrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
            disclosureNode.getChildren().add((Object)disclosureNodeArrow);
            return disclosureNode;
        }).withOnMouseClickedEvent(group -> event -> group.toggleExpansion()));
        PseudoClass rootPseudoClass = PseudoClass.getPseudoClass((String)"root");
        PseudoClass subElementPseudoClass = PseudoClass.getPseudoClass((String)"sub");
        PseudoClass dragOverBottom = PseudoClass.getPseudoClass((String)"dragOver-bottom");
        PseudoClass dragOverCenter = PseudoClass.getPseudoClass((String)"dragOver-center");
        PseudoClass dragOverTop = PseudoClass.getPseudoClass((String)"dragOver-top");
        this.groupTree.setRowFactory(treeTable -> {
            TreeTableRow row = new TreeTableRow();
            row.treeItemProperty().addListener((ov, oldTreeItem, newTreeItem) -> {
                boolean isRoot = newTreeItem == treeTable.getRoot();
                row.pseudoClassStateChanged(rootPseudoClass, isRoot);
                boolean isFirstLevel = newTreeItem != null && newTreeItem.getParent() == treeTable.getRoot();
                row.pseudoClassStateChanged(subElementPseudoClass, !isRoot && !isFirstLevel);
            });
            row.setDisclosureNode(null);
            row.disclosureNodeProperty().addListener((observable, oldValue, newValue) -> row.setDisclosureNode(null));
            row.contextMenuProperty().bind((ObservableValue)EasyBind.monadic(row.itemProperty()).map(this::createContextMenuForGroup).orElse(null));
            row.setOnDragDetected(event -> {
                TreeItem selectedItem = (TreeItem)treeTable.getSelectionModel().getSelectedItem();
                if (selectedItem != null && selectedItem.getValue() != null) {
                    Dragboard dragboard = treeTable.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    dragboard.setDragView((Image)row.snapshot(null, null));
                    ClipboardContent content = new ClipboardContent();
                    content.put((Object)DragAndDropDataFormats.GROUP, (Object)((GroupNodeViewModel)selectedItem.getValue()).getPath());
                    dragboard.setContent((Map)content);
                    event.consume();
                }
            });
            row.setOnDragOver(event -> {
                Dragboard dragboard = event.getDragboard();
                if (event.getGestureSource() != row && ((GroupNodeViewModel)row.getItem()).acceptableDrop(dragboard)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE, TransferMode.LINK});
                    GroupTreeController.removePseudoClasses((TreeTableRow<GroupNodeViewModel>)row, dragOverBottom, dragOverCenter, dragOverTop);
                    switch (this.getDroppingMouseLocation((TreeTableRow<GroupNodeViewModel>)row, (DragEvent)event)) {
                        case BOTTOM: {
                            row.pseudoClassStateChanged(dragOverBottom, true);
                            break;
                        }
                        case CENTER: {
                            row.pseudoClassStateChanged(dragOverCenter, true);
                            break;
                        }
                        case TOP: {
                            row.pseudoClassStateChanged(dragOverTop, true);
                        }
                    }
                }
                event.consume();
            });
            row.setOnDragExited(event -> GroupTreeController.removePseudoClasses((TreeTableRow<GroupNodeViewModel>)row, dragOverBottom, dragOverCenter, dragOverTop));
            row.setOnDragDropped(event -> {
                Dragboard dragboard = event.getDragboard();
                boolean success = false;
                if (dragboard.hasContent(DragAndDropDataFormats.GROUP)) {
                    String pathToSource = (String)dragboard.getContent(DragAndDropDataFormats.GROUP);
                    Optional<GroupNodeViewModel> source = ((GroupNodeViewModel)((GroupTreeViewModel)this.viewModel).rootGroupProperty().get()).getChildByPath(pathToSource);
                    if (source.isPresent()) {
                        source.get().draggedOn((GroupNodeViewModel)row.getItem(), this.getDroppingMouseLocation((TreeTableRow<GroupNodeViewModel>)row, (DragEvent)event));
                        success = true;
                    }
                }
                if (dragboard.hasContent(DragAndDropDataFormats.ENTRIES)) {
                    TransferableEntrySelection entrySelection = (TransferableEntrySelection)dragboard.getContent(DragAndDropDataFormats.ENTRIES);
                    ((GroupNodeViewModel)row.getItem()).addEntriesToGroup(entrySelection.getSelection());
                    success = true;
                }
                event.setDropCompleted(success);
                event.consume();
            });
            return row;
        });
        this.setupClearButtonField(this.searchField);
    }

    private void updateSelection(List<TreeItem<GroupNodeViewModel>> newSelectedGroups) {
        if (newSelectedGroups == null || newSelectedGroups.isEmpty()) {
            ((GroupTreeViewModel)this.viewModel).selectedGroupsProperty().clear();
        } else {
            ArrayList<GroupNodeViewModel> list = new ArrayList<GroupNodeViewModel>();
            for (TreeItem<GroupNodeViewModel> model : newSelectedGroups) {
                if (model == null || model.getValue() == null || ((GroupNodeViewModel)model.getValue()).getGroupNode().getGroup() instanceof AllEntriesGroup) continue;
                list.add((GroupNodeViewModel)model.getValue());
            }
            ((GroupTreeViewModel)this.viewModel).selectedGroupsProperty().setAll(list);
        }
    }

    private void selectNode(GroupNodeViewModel value) {
        this.getTreeItemByValue(value).ifPresent(treeItem -> this.groupTree.getSelectionModel().select(treeItem));
    }

    private Optional<TreeItem<GroupNodeViewModel>> getTreeItemByValue(GroupNodeViewModel value) {
        return this.getTreeItemByValue((TreeItem<GroupNodeViewModel>)this.groupTree.getRoot(), value);
    }

    private Optional<TreeItem<GroupNodeViewModel>> getTreeItemByValue(TreeItem<GroupNodeViewModel> root, GroupNodeViewModel value) {
        if (((GroupNodeViewModel)root.getValue()).equals(value)) {
            return Optional.of(root);
        }
        for (TreeItem child : root.getChildren()) {
            Optional<TreeItem<GroupNodeViewModel>> treeItemByValue = this.getTreeItemByValue((TreeItem<GroupNodeViewModel>)child, value);
            if (!treeItemByValue.isPresent()) continue;
            return treeItemByValue;
        }
        return Optional.empty();
    }

    private ContextMenu createContextMenuForGroup(GroupNodeViewModel group) {
        ContextMenu menu = new ContextMenu();
        MenuItem editGroup = new MenuItem(Localization.lang("Edit group", new String[0]));
        editGroup.setOnAction(event -> {
            menu.hide();
            ((GroupTreeViewModel)this.viewModel).editGroup(group);
        });
        MenuItem addSubgroup = new MenuItem(Localization.lang("Add subgroup", new String[0]));
        addSubgroup.setOnAction(event -> {
            menu.hide();
            ((GroupTreeViewModel)this.viewModel).addNewSubgroup(group);
        });
        MenuItem removeGroupAndSubgroups = new MenuItem(Localization.lang("Remove group and subgroups", new String[0]));
        removeGroupAndSubgroups.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).removeGroupAndSubgroups(group));
        MenuItem removeGroupKeepSubgroups = new MenuItem(Localization.lang("Remove group, keep subgroups", new String[0]));
        removeGroupKeepSubgroups.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).removeGroupKeepSubgroups(group));
        MenuItem removeSubgroups = new MenuItem(Localization.lang("Remove subgroups", new String[0]));
        removeSubgroups.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).removeSubgroups(group));
        MenuItem addEntries = new MenuItem(Localization.lang("Add selected entries to this group", new String[0]));
        addEntries.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).addSelectedEntries(group));
        MenuItem removeEntries = new MenuItem(Localization.lang("Remove selected entries from this group", new String[0]));
        removeEntries.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).removeSelectedEntries(group));
        MenuItem sortAlphabetically = new MenuItem(Localization.lang("Sort all subgroups (recursively)", new String[0]));
        sortAlphabetically.setOnAction(event -> ((GroupTreeViewModel)this.viewModel).sortAlphabeticallyRecursive(group));
        menu.getItems().add((Object)editGroup);
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().addAll((Object[])new MenuItem[]{addSubgroup, removeSubgroups, removeGroupAndSubgroups, removeGroupKeepSubgroups});
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().addAll((Object[])new MenuItem[]{addEntries, removeEntries});
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().add((Object)sortAlphabetically);
        return menu;
    }

    public void addNewGroup(ActionEvent actionEvent) {
        ((GroupTreeViewModel)this.viewModel).addNewGroupToRoot();
    }

    private void setupClearButtonField(CustomTextField customTextField) {
        try {
            Method m3 = TextFields.class.getDeclaredMethod("setupClearButtonField", TextField.class, ObjectProperty.class);
            m3.setAccessible(true);
            m3.invoke(null, new Object[]{customTextField, customTextField.rightProperty()});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error("Failed to decorate text field with clear button", ex);
        }
    }

    private DroppingMouseLocation getDroppingMouseLocation(TreeTableRow<GroupNodeViewModel> row, DragEvent event) {
        if (row.getHeight() * 0.25 > event.getY()) {
            return DroppingMouseLocation.TOP;
        }
        if (row.getHeight() * 0.75 < event.getY()) {
            return DroppingMouseLocation.BOTTOM;
        }
        return DroppingMouseLocation.CENTER;
    }
}

