/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.Arrays;
import java.util.List;
import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.OptionEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.Month;
import org.jabref.model.strings.StringUtil;

public class MonthEditorViewModel
extends OptionEditorViewModel<Month> {
    private BibDatabaseMode databaseMode;

    public MonthEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, BibDatabaseMode databaseMode, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.databaseMode = databaseMode;
    }

    @Override
    public StringConverter<Month> getStringConverter() {
        return new StringConverter<Month>(){

            public String toString(Month object) {
                if (object == null) {
                    return null;
                }
                if (MonthEditorViewModel.this.databaseMode == BibDatabaseMode.BIBLATEX) {
                    return String.valueOf(object.getNumber());
                }
                return object.getJabRefFormat();
            }

            public Month fromString(String string) {
                if (StringUtil.isNotBlank(string)) {
                    return Month.parse(string).orElse(null);
                }
                return null;
            }
        };
    }

    @Override
    public List<Month> getItems() {
        return Arrays.asList(Month.values());
    }

    @Override
    public String convertToDisplayText(Month object) {
        return object.getFullName();
    }
}

