/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.google.common.eventbus.Subscribe;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanelMode;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DuplicateSearch;
import org.jabref.gui.EntryMarker;
import org.jabref.gui.EntryTypeDialog;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.FindUnlinkedFilesDialog;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.PreambleEditor;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.ReplaceStringDialog;
import org.jabref.gui.SidePaneManager;
import org.jabref.gui.StringDialog;
import org.jabref.gui.TransferableBibtexEntry;
import org.jabref.gui.UpdateTimestampListener;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.actions.CleanupAction;
import org.jabref.gui.actions.CopyBibTeXKeyAndLinkAction;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.autocompleter.AutoCompleteUpdater;
import org.jabref.gui.autocompleter.PersonNameSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.bibtexkeypattern.SearchFixDuplicateLabels;
import org.jabref.gui.collab.DatabaseChangeMonitor;
import org.jabref.gui.collab.FileUpdatePanel;
import org.jabref.gui.contentselector.ContentSelectorDialog;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditor;
import org.jabref.gui.exporter.ExportToClipboardAction;
import org.jabref.gui.exporter.SaveDatabaseAction;
import org.jabref.gui.externalfiles.FindFullTextAction;
import org.jabref.gui.externalfiles.SynchronizeFileField;
import org.jabref.gui.externalfiles.WriteXMPAction;
import org.jabref.gui.externalfiletype.ExternalFileMenuItem;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.fieldeditors.FieldEditor;
import org.jabref.gui.filelist.AttachFileAction;
import org.jabref.gui.filelist.FileListEntry;
import org.jabref.gui.filelist.FileListTableModel;
import org.jabref.gui.groups.GroupAddRemoveDialog;
import org.jabref.gui.importer.actions.AppendDatabaseAction;
import org.jabref.gui.journals.AbbreviateAction;
import org.jabref.gui.journals.UnabbreviateAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.gui.maintable.MainTableFormat;
import org.jabref.gui.maintable.MainTableSelectionListener;
import org.jabref.gui.mergeentries.MergeEntriesDialog;
import org.jabref.gui.mergeentries.MergeWithFetchedEntryAction;
import org.jabref.gui.plaintextimport.TextInputDialog;
import org.jabref.gui.specialfields.SpecialFieldDatabaseChangeListener;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableChangeType;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.undo.UndoableInsertEntry;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.gui.undo.UndoableRemoveEntry;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.component.CheckBoxMessage;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.gui.worker.CallBack;
import org.jabref.gui.worker.CitationStyleToClipboardWorker;
import org.jabref.gui.worker.MarkEntriesAction;
import org.jabref.gui.worker.SendAsEMailAction;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.citationstyle.CitationStyleCache;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.exporter.BibtexDatabaseWriter;
import org.jabref.logic.exporter.FileSaveSession;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.l10n.Encodings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.logic.search.SearchQuery;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.UpdateField;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.logic.util.io.FileFinders;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.jabref.model.database.event.CoarseChangeFilter;
import org.jabref.model.database.event.EntryAddedEvent;
import org.jabref.model.database.event.EntryRemovedEvent;
import org.jabref.model.database.shared.DatabaseLocation;
import org.jabref.model.database.shared.DatabaseSynchronizer;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.entry.event.EntryChangedEvent;
import org.jabref.model.entry.event.EntryEventSource;
import org.jabref.model.entry.specialfields.SpecialField;
import org.jabref.model.entry.specialfields.SpecialFieldValue;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePanel
extends JPanel
implements ClipboardOwner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePanel.class);
    private static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    private final BibDatabaseContext bibDatabaseContext;
    private final MainTableDataModel tableModel;
    private final CitationStyleCache citationStyleCache;
    private final FileAnnotationCache annotationCache;
    private final JabRefFrame frame;
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final CountingUndoManager undoManager = new CountingUndoManager();
    private final List<BibEntry> previousEntries = new ArrayList<BibEntry>();
    private final List<BibEntry> nextEntries = new ArrayList<BibEntry>();
    private final Map<String, Object> actions = new HashMap<String, Object>();
    private final SidePaneManager sidePaneManager;
    private final PreviewPanel preview;
    private final JFXPanel previewContainer;
    private BasePanelMode mode = BasePanelMode.SHOWING_NOTHING;
    private final EntryEditor entryEditor;
    private final JFXPanel entryEditorContainer;
    private MainTableSelectionListener selectionListener;
    private JSplitPane splitPane;
    private boolean saving;
    private PersonNameSuggestionProvider searchAutoCompleter;
    private boolean baseChanged;
    private boolean nonUndoableChange;
    private MainTable mainTable;
    private MainTableFormat tableFormat;
    private BibEntry showing;
    private boolean backOrForwardInProgress;
    private PreambleEditor preambleEditor;
    private StringDialog stringDialog;
    private SuggestionProviders suggestionProviders;
    private Optional<SearchQuery> currentSearchQuery = Optional.empty();
    private Optional<DatabaseChangeMonitor> changeMonitor = Optional.empty();

    public BasePanel(JabRefFrame frame, BibDatabaseContext bibDatabaseContext) {
        Objects.requireNonNull(frame);
        Objects.requireNonNull(bibDatabaseContext);
        this.bibDatabaseContext = bibDatabaseContext;
        bibDatabaseContext.getDatabase().registerListener(this);
        bibDatabaseContext.getMetaData().registerListener(this);
        this.sidePaneManager = frame.getSidePaneManager();
        this.frame = frame;
        this.tableModel = new MainTableDataModel(this.getBibDatabaseContext());
        this.citationStyleCache = new CitationStyleCache(bibDatabaseContext);
        this.annotationCache = new FileAnnotationCache(bibDatabaseContext, Globals.prefs.getFileDirectoryPreferences());
        this.preview = new PreviewPanel(this, this.getBibDatabaseContext());
        DefaultTaskExecutor.runInJavaFXThread(() -> this.frame().getGlobalSearchBar().getSearchQueryHighlightObservable().addSearchListener(this.preview));
        this.previewContainer = CustomJFXPanel.wrap(new Scene((Parent)this.preview));
        this.setupMainPanel();
        this.setupActions();
        this.getDatabase().registerListener(new SearchListener());
        this.getDatabase().registerListener(new EntryRemovedListener());
        this.bibDatabaseContext.getDatabase().registerListener(new GroupTreeListener());
        Optional<File> file = bibDatabaseContext.getDatabaseFile();
        if (file.isPresent()) {
            this.changeMonitor = Optional.of(new DatabaseChangeMonitor(bibDatabaseContext, Globals.getFileUpdateMonitor(), this));
        } else if (bibDatabaseContext.getDatabase().hasEntries()) {
            this.baseChanged = true;
        }
        this.getDatabase().registerListener(new UpdateTimestampListener(Globals.prefs));
        this.entryEditor = new EntryEditor(this);
        this.entryEditorContainer = BasePanel.setupEntryEditor(this.entryEditor);
    }

    private static JFXPanel setupEntryEditor(EntryEditor entryEditor) {
        JFXPanel container = CustomJFXPanel.wrap(new Scene((Parent)entryEditor));
        container.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Optional<KeyBinding> keyBinding = Globals.getKeyPrefs().mapToKeyBinding(e);
                if (keyBinding.isPresent()) {
                    switch (keyBinding.get()) {
                        case CUT: 
                        case COPY: 
                        case PASTE: 
                        case DELETE_ENTRY: 
                        case SELECT_ALL: {
                            e.consume();
                            break;
                        }
                    }
                }
            }
        });
        return container;
    }

    public static void runWorker(AbstractWorker worker) throws Exception {
        Runnable wrk = worker.getWorker();
        CallBack clb = worker.getCallBack();
        worker.init();
        wrk.run();
        clb.update();
    }

    @Subscribe
    public void listen(BibDatabaseContextChangedEvent event) {
        SwingUtilities.invokeLater(() -> this.markBaseChanged());
    }

    public SuggestionProviders getSuggestionProviders() {
        return this.suggestionProviders;
    }

    public String getTabTitle() {
        StringBuilder title = new StringBuilder();
        DatabaseLocation databaseLocation = this.bibDatabaseContext.getLocation();
        boolean isAutosaveEnabled = Globals.prefs.getBoolean("localAutoSave");
        if (databaseLocation == DatabaseLocation.LOCAL) {
            if (this.bibDatabaseContext.getDatabaseFile().isPresent()) {
                String changeFlag = this.isModified() && !isAutosaveEnabled ? "*" : "";
                title.append(this.bibDatabaseContext.getDatabaseFile().get().getName()).append(changeFlag);
            } else {
                title.append(GUIGlobals.UNTITLED_TITLE);
                if (this.getDatabase().hasEntries()) {
                    title.append('*');
                }
            }
        } else if (databaseLocation == DatabaseLocation.SHARED) {
            title.append(this.bibDatabaseContext.getDBMSSynchronizer().getDBName() + " [" + Localization.lang("shared", new String[0]) + "]");
        }
        return title.toString();
    }

    public boolean isModified() {
        return this.baseChanged;
    }

    public BasePanelMode getMode() {
        return this.mode;
    }

    public void setMode(BasePanelMode mode) {
        this.mode = mode;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public void output(String s2) {
        this.frame.output(s2);
    }

    private void setupActions() {
        SaveDatabaseAction saveAction = new SaveDatabaseAction(this);
        CleanupAction cleanUpAction = new CleanupAction(this, Globals.prefs);
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("focusTable", () -> this.mainTable.requestFocus());
        this.actions.put("edit", this.selectionListener::editSignalled);
        this.actions.put("save", saveAction);
        this.actions.put("saveAs", saveAction::saveAs);
        this.actions.put("saveSelectedAs", new SaveSelectedAction(SavePreferences.DatabaseSaveType.ALL));
        this.actions.put("saveSelectedAsPlain", new SaveSelectedAction(SavePreferences.DatabaseSaveType.PLAIN_BIBTEX));
        this.actions.put("copy", () -> this.copy());
        this.actions.put("printPreview", new PrintPreviewAction());
        this.actions.put("cut", this::cut);
        this.actions.put("delete", () -> this.delete(false));
        this.actions.put("paste", () -> this.paste());
        this.actions.put("selectAll", this.mainTable::selectAll);
        this.actions.put("editPreamble", () -> {
            if (this.preambleEditor == null) {
                PreambleEditor form = new PreambleEditor(this.frame, this, this.bibDatabaseContext.getDatabase());
                form.setLocationRelativeTo(this.frame);
                form.setVisible(true);
                this.preambleEditor = form;
            } else {
                this.preambleEditor.setVisible(true);
            }
        });
        this.actions.put("editStrings", () -> {
            if (this.stringDialog == null) {
                StringDialog form = new StringDialog(this.frame, this, this.bibDatabaseContext.getDatabase());
                form.setVisible(true);
                this.stringDialog = form;
            } else {
                this.stringDialog.setVisible(true);
            }
        });
        this.actions.put("findUnlinkedFiles", () -> {
            FindUnlinkedFilesDialog dialog = new FindUnlinkedFilesDialog((Frame)this.frame, this.frame, this);
            dialog.setLocationRelativeTo(this.frame);
            dialog.setVisible(true);
        });
        this.actions.put("makeKey", new AbstractWorker(){
            List<BibEntry> entries;
            int numSelected;
            boolean canceled;

            @Override
            public void init() {
                this.entries = BasePanel.this.getSelectedEntries();
                this.numSelected = this.entries.size();
                if (this.entries.isEmpty()) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Localization.lang("First select the entries you want keys to be generated for.", new String[0]), Localization.lang("Autogenerate BibTeX keys", new String[0]), 1);
                    return;
                }
                BasePanel.this.frame.block();
                BasePanel.this.output(BasePanel.this.formatOutputMessage(Localization.lang("Generating BibTeX key for", new String[0]), this.numSelected));
            }

            @Override
            public void run() {
                if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    this.entries.removeIf(BibEntry::hasCiteKey);
                } else if (Globals.prefs.getBoolean("warnBeforeOverwritingKey") && this.entries.parallelStream().anyMatch(BibEntry::hasCiteKey)) {
                    CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("One or more keys will be overwritten. Continue?", new String[0]), Localization.lang("Disable this confirmation dialog", new String[0]), false);
                    int answer = JOptionPane.showConfirmDialog(BasePanel.this.frame, cbm, Localization.lang("Overwrite keys", new String[0]), 0);
                    Globals.prefs.putBoolean("warnBeforeOverwritingKey", !cbm.isSelected());
                    if (answer == 1) {
                        this.canceled = true;
                        return;
                    }
                }
                NamedCompound ce = new NamedCompound(Localization.lang("Autogenerate BibTeX keys", new String[0]));
                BibtexKeyGenerator keyGenerator = new BibtexKeyGenerator(BasePanel.this.bibDatabaseContext, Globals.prefs.getBibtexKeyPatternPreferences());
                for (BibEntry entry : this.entries) {
                    Optional<FieldChange> change = keyGenerator.generateAndSetKey(entry);
                    change.ifPresent(fieldChange -> ce.addEdit(new UndoableKeyChange((FieldChange)fieldChange)));
                }
                ce.end();
                if (ce.hasEdits()) {
                    BasePanel.this.getUndoManager().addEdit(ce);
                }
            }

            @Override
            public void update() {
                if (this.canceled) {
                    BasePanel.this.frame.unblock();
                    return;
                }
                BasePanel.this.markBaseChanged();
                this.numSelected = this.entries.size();
                for (BibEntry bibEntry : this.entries) {
                    SwingUtilities.invokeLater(() -> {
                        int row = BasePanel.this.mainTable.findEntry(bibEntry);
                        if (row >= 0 && BasePanel.this.mainTable.getSelectedRowCount() < this.entries.size()) {
                            BasePanel.this.mainTable.addRowSelectionInterval(row, row);
                        }
                    });
                }
                BasePanel.this.output(BasePanel.this.formatOutputMessage(Localization.lang("Generated BibTeX key for", new String[0]), this.numSelected));
                BasePanel.this.frame.unblock();
            }
        });
        this.actions.put("Cleanup", cleanUpAction);
        this.actions.put("mergeEntries", () -> new MergeEntriesDialog(this));
        this.actions.put("search", this.frame.getGlobalSearchBar()::focus);
        this.actions.put("globalSearch", this.frame.getGlobalSearchBar()::performGlobalSearch);
        this.actions.put("copyKey", () -> this.copyKey());
        this.actions.put("copyTitle", () -> this.copyTitle());
        this.actions.put("copyCiteKey", () -> this.copyCiteKey());
        this.actions.put("copyKeyAndTitle", () -> this.copyKeyAndTitle());
        this.actions.put("copyCitaitonAsciidoc", () -> this.copyCitationToClipboard(CitationStyleOutputFormat.ASCII_DOC));
        this.actions.put("copyCitaitonFo", () -> this.copyCitationToClipboard(CitationStyleOutputFormat.XSL_FO));
        this.actions.put("copyCitaitonHtml", () -> this.copyCitationToClipboard(CitationStyleOutputFormat.HTML));
        this.actions.put("copyCitaitonRtf", () -> this.copyCitationToClipboard(CitationStyleOutputFormat.RTF));
        this.actions.put("copyCitaitonText", () -> this.copyCitationToClipboard(CitationStyleOutputFormat.TEXT));
        this.actions.put("copyKeyAndLink", new CopyBibTeXKeyAndLinkAction(this.mainTable));
        this.actions.put("mergeDatabase", new AppendDatabaseAction(this.frame, this));
        this.actions.put("addFileLink", new AttachFileAction(this));
        this.actions.put("openExternalFile", () -> this.openExternalFile());
        this.actions.put("openFolder", () -> JabRefExecutorService.INSTANCE.execute(() -> {
            List<Path> files = FileUtil.getListOfLinkedFiles(this.mainTable.getSelectedEntries(), this.bibDatabaseContext.getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences()));
            for (Path f : files) {
                try {
                    JabRefDesktop.openFolderAndSelectFile(f.toAbsolutePath());
                }
                catch (IOException e) {
                    LOGGER.info("Could not open folder", e);
                }
            }
        }));
        this.actions.put("openConsole", () -> JabRefDesktop.openConsole(this.frame.getCurrentBasePanel().getBibDatabaseContext().getDatabaseFile().orElse(null)));
        this.actions.put("pullChangesFromSharedDatabase", () -> {
            DatabaseSynchronizer dbmsSynchronizer = this.frame.getCurrentBasePanel().getBibDatabaseContext().getDBMSSynchronizer();
            dbmsSynchronizer.pullChanges();
        });
        this.actions.put("openUrl", new OpenURLAction());
        this.actions.put("mergeWithFetchedEntry", new MergeWithFetchedEntryAction(this));
        this.actions.put("replaceAll", () -> {
            ReplaceStringDialog rsd = new ReplaceStringDialog(this.frame);
            rsd.setVisible(true);
            if (!rsd.okPressed()) {
                return;
            }
            int counter = 0;
            NamedCompound ce = new NamedCompound(Localization.lang("Replace string", new String[0]));
            if (rsd.selOnly()) {
                for (BibEntry be : this.mainTable.getSelectedEntries()) {
                    counter += rsd.replace(be, ce);
                }
            } else {
                for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
                    counter += rsd.replace(entry, ce);
                }
            }
            this.output(Localization.lang("Replaced", new String[0]) + ' ' + counter + ' ' + (counter == 1 ? Localization.lang("occurrence", new String[0]) : Localization.lang("occurrences", new String[0])) + '.');
            if (counter > 0) {
                ce.end();
                this.getUndoManager().addEdit(ce);
                this.markBaseChanged();
            }
        });
        this.actions.put("dupliCheck", () -> JabRefExecutorService.INSTANCE.execute(new DuplicateSearch(this)));
        this.actions.put("plainTextImport", () -> {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            etd.setLocationRelativeTo(this);
            etd.setVisible(true);
            EntryType tp = etd.getChoice();
            if (tp == null) {
                return;
            }
            BibEntry bibEntry = new BibEntry(tp.getName());
            TextInputDialog tidialog = new TextInputDialog(this.frame, bibEntry);
            tidialog.setLocationRelativeTo(this);
            tidialog.setVisible(true);
            if (tidialog.okPressed()) {
                UpdateField.setAutomaticFields(Collections.singletonList(bibEntry), false, false, Globals.prefs.getUpdateFieldPreferences());
                this.insertEntry(bibEntry);
            }
        });
        this.actions.put("markEntries", new MarkEntriesAction(this.frame, 0));
        this.actions.put("unmarkEntries", () -> {
            try {
                List<BibEntry> bes = this.mainTable.getSelectedEntries();
                if (bes.isEmpty()) {
                    this.output(Localization.lang("This operation requires one or more entries to be selected.", new String[0]));
                    return;
                }
                NamedCompound ce = new NamedCompound(Localization.lang("Unmark entries", new String[0]));
                for (BibEntry be : bes) {
                    EntryMarker.unmarkEntry(be, false, this.bibDatabaseContext.getDatabase(), ce);
                }
                ce.end();
                this.getUndoManager().addEdit(ce);
                this.markBaseChanged();
                String outputStr = bes.size() == 1 ? Localization.lang("Unmarked selected entry", new String[0]) : Localization.lang("Unmarked all %0 selected entries", Integer.toString(bes.size()));
                this.output(outputStr);
            }
            catch (Throwable ex) {
                LOGGER.warn("Could not unmark", ex);
            }
        });
        this.actions.put("unmarkAll", () -> {
            NamedCompound ce = new NamedCompound(Localization.lang("Unmark all", new String[0]));
            for (BibEntry be : this.bibDatabaseContext.getDatabase().getEntries()) {
                EntryMarker.unmarkEntry(be, false, this.bibDatabaseContext.getDatabase(), ce);
            }
            ce.end();
            this.getUndoManager().addEdit(ce);
            this.markBaseChanged();
            this.output(Localization.lang("Unmarked all entries", new String[0]));
        });
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.RELEVANCE).getSpecialFieldAction(SpecialField.RELEVANCE.getValues().get(0), this.frame));
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.QUALITY).getSpecialFieldAction(SpecialField.QUALITY.getValues().get(0), this.frame));
        this.actions.put(new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)).getActionName(), new SpecialFieldViewModel(SpecialField.PRINTED).getSpecialFieldAction(SpecialField.PRINTED.getValues().get(0), this.frame));
        for (SpecialFieldValue prio : SpecialField.PRIORITY.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(prio).getActionName(), new SpecialFieldViewModel(SpecialField.PRIORITY).getSpecialFieldAction(prio, this.frame));
        }
        for (SpecialFieldValue rank : SpecialField.RANKING.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(rank).getActionName(), new SpecialFieldViewModel(SpecialField.RANKING).getSpecialFieldAction(rank, this.frame));
        }
        for (SpecialFieldValue status : SpecialField.READ_STATUS.getValues()) {
            this.actions.put(new SpecialFieldValueViewModel(status).getActionName(), new SpecialFieldViewModel(SpecialField.READ_STATUS).getSpecialFieldAction(status, this.frame));
        }
        this.actions.put("togglePreview", () -> {
            PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
            boolean enabled = !previewPreferences.isPreviewPanelEnabled();
            PreviewPreferences newPreviewPreferences = previewPreferences.getBuilder().withPreviewPanelEnabled(enabled).build();
            Globals.prefs.storePreviewPreferences(newPreviewPreferences);
            this.setPreviewActiveBasePanels(enabled);
            this.frame.setPreviewToggle(enabled);
        });
        this.actions.put("nextPreviewStyle", this::nextPreviewStyle);
        this.actions.put("previousPreviewStyle", this::previousPreviewStyle);
        this.actions.put("manageSelectors", () -> {
            ContentSelectorDialog csd = new ContentSelectorDialog(this.frame, this.frame, this, false, null);
            csd.setLocationRelativeTo(this.frame);
            csd.setVisible(true);
        });
        this.actions.put("exportToClipboard", new ExportToClipboardAction(this.frame));
        this.actions.put("sendAsEmail", new SendAsEMailAction(this.frame));
        this.actions.put("writeXMP", new WriteXMPAction(this));
        this.actions.put("abbreviateIso", new AbbreviateAction(this, true));
        this.actions.put("abbreviateMedline", new AbbreviateAction(this, false));
        this.actions.put("unabbreviate", new UnabbreviateAction(this));
        this.actions.put("autoSetFile", new SynchronizeFileField(this));
        this.actions.put("back", this::back);
        this.actions.put("forward", this::forward);
        this.actions.put("resolveDuplicateKeys", new SearchFixDuplicateLabels(this));
        this.actions.put("addToGroup", new GroupAddRemoveDialog(this, true, false));
        this.actions.put("removeFromGroup", new GroupAddRemoveDialog(this, false, false));
        this.actions.put("moveToGroup", new GroupAddRemoveDialog(this, true, true));
        this.actions.put("downloadFullText", new FindFullTextAction(this));
    }

    private void copyCitationToClipboard(CitationStyleOutputFormat outputFormat) {
        new CitationStyleToClipboardWorker(this, outputFormat).execute();
    }

    private void copy() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (bes.isEmpty()) {
            Object o;
            int[] rows = this.mainTable.getSelectedRows();
            int[] cols = this.mainTable.getSelectedColumns();
            if (cols.length == 1 && rows.length == 1 && (o = this.mainTable.getValueAt(rows[0], cols[0])) != null) {
                StringSelection ss = new StringSelection(o.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
                this.output(Localization.lang("Copied cell contents", new String[0]) + '.');
            }
        } else {
            TransferableBibtexEntry trbe = new TransferableBibtexEntry(bes);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trbe, this);
            this.output(this.formatOutputMessage(Localization.lang("Copied", new String[0]), bes.size()));
        }
    }

    private void cut() {
        this.runCommand("copy");
        this.delete(true);
    }

    private void delete(boolean cut) {
        this.delete(cut, this.mainTable.getSelectedEntries());
    }

    private void delete(boolean cut, List<BibEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (!cut && !this.showDeleteConfirmationDialog(entries.size())) {
            return;
        }
        if (this.mainTable.getSelectedRow() != this.mainTable.getRowCount() - 1) {
            this.selectNextEntry();
        } else {
            this.selectPreviousEntry();
        }
        NamedCompound compound = cut ? new NamedCompound(entries.size() > 1 ? Localization.lang("cut entries", new String[0]) : Localization.lang("cut entry", new String[0])) : new NamedCompound(entries.size() > 1 ? Localization.lang("delete entries", new String[0]) : Localization.lang("delete entry", new String[0]));
        for (BibEntry entry : entries) {
            compound.addEdit(new UndoableRemoveEntry(this.bibDatabaseContext.getDatabase(), entry, this));
            this.bibDatabaseContext.getDatabase().removeEntry(entry);
            this.ensureNotShowingBottomPanel(entry);
        }
        compound.end();
        this.getUndoManager().addEdit(compound);
        this.markBaseChanged();
        this.frame.output(this.formatOutputMessage(cut ? Localization.lang("Cut", new String[0]) : Localization.lang("Deleted", new String[0]), entries.size()));
        this.mainTable.requestFocus();
    }

    public void delete(BibEntry entry) {
        this.delete(false, Collections.singletonList(entry));
    }

    private void paste() {
        List<BibEntry> bes = new ClipBoardManager().extractBibEntriesFromClipboard();
        if (!bes.isEmpty()) {
            NamedCompound ce = new NamedCompound(bes.size() > 1 ? Localization.lang("paste entries", new String[0]) : Localization.lang("paste entry", new String[0]));
            BibEntry firstBE = null;
            for (BibEntry be1 : bes) {
                BibEntry be = (BibEntry)be1.clone();
                if (firstBE == null) {
                    firstBE = be;
                }
                UpdateField.setAutomaticFields(be, Globals.prefs.getUpdateFieldPreferences());
                this.bibDatabaseContext.getDatabase().insertEntry(be);
                ce.addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), be, this));
            }
            ce.end();
            this.getUndoManager().addEdit(ce);
            this.output(this.formatOutputMessage(Localization.lang("Pasted", new String[0]), bes.size()));
            this.markBaseChanged();
            this.highlightEntry(firstBE);
            this.mainTable.requestFocus();
            if (Globals.prefs.getBoolean("autoOpenForm")) {
                this.selectionListener.editSignalled(firstBE);
            }
        }
    }

    private void copyTitle() {
        List<BibEntry> selectedBibEntries = this.mainTable.getSelectedEntries();
        if (!selectedBibEntries.isEmpty()) {
            List titles = selectedBibEntries.stream().filter(bibEntry -> bibEntry.getTitle().isPresent()).map(bibEntry -> bibEntry.getTitle().get()).collect(Collectors.toList());
            if (titles.isEmpty()) {
                this.output(Localization.lang("None of the selected entries have titles.", new String[0]));
                return;
            }
            StringSelection ss = new StringSelection(String.join((CharSequence)"\n", titles));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (titles.size() == selectedBibEntries.size()) {
                this.output((selectedBibEntries.size() > 1 ? Localization.lang("Copied titles", new String[0]) : Localization.lang("Copied title", new String[0])) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined title.", Integer.toString(selectedBibEntries.size() - titles.size()), Integer.toString(selectedBibEntries.size())));
            }
        }
    }

    private void copyCiteKey() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            ArrayList keys = new ArrayList(bes.size());
            for (BibEntry be : bes) {
                be.getCiteKeyOptional().ifPresent(keys::add);
            }
            if (keys.isEmpty()) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            String sb = String.join((CharSequence)",", keys);
            String citeCommand = Optional.ofNullable(Globals.prefs.get("citeCommand")).filter(cite -> cite.contains("\\")).orElse("\\cite");
            StringSelection ss = new StringSelection(citeCommand + "{" + sb + '}');
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (keys.size() == bes.size()) {
                this.output(bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0]) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - keys.size()), Integer.toString(bes.size())));
            }
        }
    }

    private void copyKey() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            ArrayList keys = new ArrayList(bes.size());
            for (BibEntry be : bes) {
                be.getCiteKeyOptional().ifPresent(keys::add);
            }
            if (keys.isEmpty()) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            StringSelection ss = new StringSelection(String.join((CharSequence)",", keys));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (keys.size() == bes.size()) {
                this.output((bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - keys.size()), Integer.toString(bes.size())));
            }
        }
    }

    private void copyKeyAndTitle() {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        if (!bes.isEmpty()) {
            Layout layout;
            StringReader sr = new StringReader("\\bibtexkey - \\begin{title}\\format[RemoveBrackets]{\\title}\\end{title}\n");
            try {
                layout = new LayoutHelper(sr, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader)).getLayoutFromText();
            }
            catch (IOException e) {
                LOGGER.info("Could not get layout", e);
                return;
            }
            StringBuilder sb = new StringBuilder();
            int copied = 0;
            for (BibEntry be : bes) {
                if (!be.hasCiteKey()) continue;
                ++copied;
                sb.append(layout.doLayout(be, this.bibDatabaseContext.getDatabase()));
            }
            if (copied == 0) {
                this.output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            StringSelection ss = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, this);
            if (copied == bes.size()) {
                this.output((bes.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                this.output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Integer.toString(bes.size() - copied), Integer.toString(bes.size())));
            }
        }
    }

    private void openExternalFile() {
        JabRefExecutorService.INSTANCE.execute(() -> {
            List<BibEntry> selectedEntries = this.mainTable.getSelectedEntries();
            if (selectedEntries.size() != 1) {
                this.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
                return;
            }
            BibEntry entry = selectedEntries.get(0);
            if (!entry.hasField("file")) {
                new SearchAndOpenFile(entry, this).searchAndOpen();
                return;
            }
            FileListTableModel fileListTableModel = new FileListTableModel();
            entry.getField("file").ifPresent(fileListTableModel::setContent);
            if (fileListTableModel.getRowCount() == 0) {
                new SearchAndOpenFile(entry, this).searchAndOpen();
                return;
            }
            FileListEntry flEntry = fileListTableModel.getEntry(0);
            ExternalFileMenuItem item = new ExternalFileMenuItem(this.frame(), entry, "", flEntry.getLink(), flEntry.getType().get().getIcon(), this.bibDatabaseContext, flEntry.getType());
            item.doClick();
        });
    }

    public void runCommand(String _command) {
        if (!this.actions.containsKey(_command)) {
            LOGGER.info("No action defined for '" + _command + '\'');
            return;
        }
        Object o = this.actions.get(_command);
        try {
            if (o instanceof BaseAction) {
                ((BaseAction)o).action();
            } else {
                BasePanel.runWorker((AbstractWorker)o);
            }
        }
        catch (Throwable ex) {
            this.frame.unblock();
            LOGGER.error("runCommand error: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveDatabase(File file, boolean selectedOnly, Charset enc, SavePreferences.DatabaseSaveType saveType) throws SaveException {
        Object session;
        this.frame.block();
        String SAVE_DATABASE = Localization.lang("Save library", new String[0]);
        try {
            SavePreferences prefs = Globals.prefs.loadForSaveFromPreferences().withEncoding(enc).withSaveType(saveType);
            BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
            session = selectedOnly ? databaseWriter.savePartOfDatabase(this.bibDatabaseContext, this.mainTable.getSelectedEntries(), prefs) : databaseWriter.saveDatabase(this.bibDatabaseContext, prefs);
            this.registerUndoableChanges((SaveSession)session);
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + ' ' + Localization.lang("Character encoding '%0' is not supported.", enc.displayName()), SAVE_DATABASE, 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex.specificEntry()) {
                this.highlightEntry(ex.getEntry());
                this.showAndEdit(ex.getEntry());
            } else {
                LOGGER.warn("Could not save", ex);
            }
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + "\n" + ex.getMessage(), SAVE_DATABASE, 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean commit = true;
        if (!((SaveSession)session).getWriter().couldEncodeAll()) {
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "pref, 4dlu, pref"));
            JTextArea ta = new JTextArea(((SaveSession)session).getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.add(Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()), new Object[0]).xy(1, 1);
            builder.add(ta).xy(3, 1);
            builder.add(Localization.lang("What do you want to do?", new String[0]), new Object[0]).xy(1, 3);
            String tryDiff = Localization.lang("Try different encoding", new String[0]);
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), SAVE_DATABASE, 1, 2, null, new String[]{Localization.lang("Save", new String[0]), tryDiff, Localization.lang("Cancel", new String[0])}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Localization.lang("Select encoding", new String[0]), SAVE_DATABASE, 3, null, Encodings.ENCODINGS_DISPLAYNAMES, enc);
                if (choice != null) {
                    Charset newEncoding = Charset.forName((String)choice);
                    return this.saveDatabase(file, selectedOnly, newEncoding, saveType);
                }
                commit = false;
            } else if (answer == 2) {
                commit = false;
            }
        }
        if (commit) {
            ((SaveSession)session).commit(file.toPath());
            this.bibDatabaseContext.getMetaData().setEncoding(enc);
            return commit;
        }
        ((SaveSession)session).cancel();
        return commit;
    }

    public void registerUndoableChanges(SaveSession session) {
        NamedCompound ce = new NamedCompound(Localization.lang("Save actions", new String[0]));
        for (FieldChange change : session.getFieldChanges()) {
            ce.addEdit(new UndoableFieldChange(change));
        }
        ce.end();
        if (ce.hasEdits()) {
            this.getUndoManager().addEdit(ce);
        }
    }

    public BibEntry newEntry(EntryType type) {
        EntryType actualType = type;
        if (actualType == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            etd.setLocationRelativeTo(this.frame);
            etd.setVisible(true);
            actualType = etd.getChoice();
        }
        if (actualType != null) {
            BibEntry be = new BibEntry(actualType.getName());
            try {
                this.bibDatabaseContext.getDatabase().insertEntry(be);
                ArrayList<BibEntry> list = new ArrayList<BibEntry>();
                list.add(be);
                UpdateField.setAutomaticFields(list, true, true, Globals.prefs.getUpdateFieldPreferences());
                this.getUndoManager().addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), be, this));
                this.output(Localization.lang("Added new '%0' entry.", actualType.getName().toLowerCase(Locale.ROOT)));
                if (this.mode != BasePanelMode.SHOWING_EDITOR) {
                    this.mode = BasePanelMode.WILL_SHOW_EDITOR;
                }
                this.highlightEntry(be);
                this.markBaseChanged();
                this.showAndEdit(be);
                return be;
            }
            catch (KeyCollisionException ex) {
                LOGGER.info(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public void insertEntry(BibEntry bibEntry) {
        if (bibEntry != null) {
            try {
                this.bibDatabaseContext.getDatabase().insertEntry(bibEntry);
                if (Globals.prefs.getBoolean("useOwner")) {
                    UpdateField.setAutomaticFields(bibEntry, true, true, Globals.prefs.getUpdateFieldPreferences());
                }
                this.getUndoManager().addEdit(new UndoableInsertEntry(this.bibDatabaseContext.getDatabase(), bibEntry, this));
                this.output(Localization.lang("Added new '%0' entry.", bibEntry.getType()));
                this.markBaseChanged();
                if (Globals.prefs.getBoolean("autoOpenForm")) {
                    this.selectionListener.editSignalled(bibEntry);
                }
                this.highlightEntry(bibEntry);
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Collision for bibtex key" + bibEntry.getId(), ex);
            }
        }
    }

    public void editEntryByIdAndFocusField(String entryId, String fieldName) {
        this.bibDatabaseContext.getDatabase().getEntryById(entryId).ifPresent(entry -> {
            this.mainTable.setSelected(this.mainTable.findEntry((BibEntry)entry));
            this.selectionListener.editSignalled();
            this.showAndEdit((BibEntry)entry);
            this.entryEditor.setFocusToField(fieldName);
        });
    }

    public void updateTableFont() {
        this.mainTable.updateFont();
    }

    private void createMainTable() {
        this.bibDatabaseContext.getDatabase().registerListener(this.tableModel.getListSynchronizer());
        this.bibDatabaseContext.getDatabase().registerListener(SpecialFieldDatabaseChangeListener.getInstance());
        this.tableFormat = new MainTableFormat(this.bibDatabaseContext.getDatabase());
        this.tableFormat.updateTableFormat();
        this.mainTable = new MainTable(this.tableFormat, this.tableModel, this.frame, this);
        this.selectionListener = new MainTableSelectionListener(this, this.mainTable);
        this.mainTable.updateFont();
        this.mainTable.addSelectionListener(this.selectionListener);
        this.mainTable.addMouseListener(this.selectionListener);
        this.mainTable.addKeyListener(this.selectionListener);
        this.mainTable.addFocusListener(this.selectionListener);
        this.mainTable.addSelectionListener(listEvent -> Platform.runLater(() -> Globals.stateManager.setSelectedEntries(this.mainTable.getSelectedEntries())));
        String clearSearch = "clearSearch";
        this.mainTable.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.CLEAR_SEARCH), clearSearch);
        this.mainTable.getActionMap().put(clearSearch, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (BasePanel.this.mode) {
                    case SHOWING_NOTHING: {
                        BasePanel.this.frame.getGlobalSearchBar().endSearch();
                        break;
                    }
                    case SHOWING_PREVIEW: {
                        BasePanel.this.getPreviewPanel().close();
                        break;
                    }
                    case SHOWING_EDITOR: 
                    case WILL_SHOW_EDITOR: {
                        BasePanel.this.entryEditorClosing(BasePanel.this.getEntryEditor());
                        break;
                    }
                    default: {
                        LOGGER.warn("unknown BasePanelMode: '" + (Object)((Object)BasePanel.this.mode) + "', doing nothing");
                    }
                }
            }
        });
        this.mainTable.getActionMap().put("cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not cut", ex);
                }
            }
        });
        this.mainTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not copy", ex);
                }
            }
        });
        this.mainTable.getActionMap().put("paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not paste", ex);
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (e.isControlDown()) {
                    switch (keyCode) {
                        case 34: {
                            ((BasePanel)BasePanel.this).frame.nextTab.actionPerformed(null);
                            e.consume();
                            break;
                        }
                        case 33: {
                            ((BasePanel)BasePanel.this).frame.prevTab.actionPerformed(null);
                            e.consume();
                            break;
                        }
                    }
                } else if (keyCode == 10) {
                    e.consume();
                    try {
                        BasePanel.this.runCommand("edit");
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("Could not run action based on key press", ex);
                    }
                }
            }
        });
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(4);
        this.adjustSplitter();
        boolean floatSearchActive = this.mainTable != null && this.tableModel.getSearchState() == MainTableDataModel.DisplayOption.FLOAT;
        this.createMainTable();
        this.splitPane.setTopComponent(this.mainTable.getPane());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            this.mode = BasePanelMode.SHOWING_NOTHING;
            this.highlightEntry(this.selectionListener.getPreview().getEntry());
        } else if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            this.mode = BasePanelMode.SHOWING_NOTHING;
        } else {
            this.splitPane.setBottomComponent(null);
        }
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.splitPane, "Center");
        this.instantiateSearchAutoCompleter();
        this.getDatabase().registerListener(new SearchAutoCompleteListener());
        this.setupAutoCompletion();
        if (floatSearchActive) {
            this.mainTable.showFloatSearch();
        }
        this.splitPane.revalidate();
        this.revalidate();
        this.repaint();
        this.splitPane.addPropertyChangeListener("dividerLocation", event -> this.saveDividerLocation());
    }

    private void setupAutoCompletion() {
        AutoCompletePreferences autoCompletePreferences = Globals.prefs.getAutoCompletePreferences();
        if (autoCompletePreferences.shouldAutoComplete()) {
            this.suggestionProviders = new SuggestionProviders(autoCompletePreferences, Globals.journalAbbreviationLoader);
            this.suggestionProviders.indexDatabase(this.getDatabase());
            CoarseChangeFilter changeFilter = new CoarseChangeFilter(this.bibDatabaseContext);
            changeFilter.registerListener(new AutoCompleteUpdater(this.suggestionProviders));
        } else {
            this.suggestionProviders = new SuggestionProviders();
        }
    }

    public void updateSearchManager() {
        this.frame.getGlobalSearchBar().setAutoCompleter(this.searchAutoCompleter);
    }

    private void instantiateSearchAutoCompleter() {
        this.searchAutoCompleter = new PersonNameSuggestionProvider(InternalBibtexFields.getPersonNameFields());
        for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
            this.searchAutoCompleter.indexEntry(entry);
        }
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void adjustSplitter() {
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getPreviewPreferences().getPreviewPanelHeight());
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getInt("entryEditorHeight"));
        }
    }

    public EntryEditor getEntryEditor() {
        return this.entryEditor;
    }

    public void showAndEdit(BibEntry entry) {
        if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
        this.mode = BasePanelMode.SHOWING_EDITOR;
        this.splitPane.setBottomComponent((Component)this.entryEditorContainer);
        DefaultTaskExecutor.runInJavaFXThread(() -> {
            if (entry != this.getShowing()) {
                this.entryEditor.setEntry(entry);
                this.newEntryShowing(entry);
            }
            this.entryEditor.requestFocus();
        });
        this.adjustSplitter();
    }

    public void showPreview(BibEntry entry) {
        this.preview.setEntry(entry);
        this.mode = BasePanelMode.SHOWING_PREVIEW;
        this.splitPane.setBottomComponent((Component)this.previewContainer);
        this.adjustSplitter();
    }

    private void showPreview() {
        if (!this.mainTable.getSelected().isEmpty()) {
            this.showPreview((BibEntry)this.mainTable.getSelected().get(0));
        }
    }

    public void nextPreviewStyle() {
        this.cyclePreview(Globals.prefs.getPreviewPreferences().getPreviewCyclePosition() + 1);
    }

    public void previousPreviewStyle() {
        this.cyclePreview(Globals.prefs.getPreviewPreferences().getPreviewCyclePosition() - 1);
    }

    private void cyclePreview(int newPosition) {
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences().getBuilder().withPreviewCyclePosition(newPosition).build();
        Globals.prefs.storePreviewPreferences(previewPreferences);
        this.preview.updateLayout(previewPreferences);
    }

    public void hideBottomComponent() {
        this.mode = BasePanelMode.SHOWING_NOTHING;
        this.splitPane.setBottomComponent(null);
    }

    public void highlightEntry(BibEntry bibEntry) {
        this.highlightEntry(this.mainTable.findEntry(bibEntry));
    }

    public void highlightEntry(int pos) {
        if (pos >= 0 && pos < this.mainTable.getRowCount()) {
            this.mainTable.setRowSelectionInterval(pos, pos);
            this.mainTable.ensureVisible(pos);
        }
    }

    public void selectPreviousEntry() {
        this.highlightEntry((this.mainTable.getSelectedRow() - 1 + this.mainTable.getRowCount()) % this.mainTable.getRowCount());
    }

    public void selectNextEntry() {
        this.highlightEntry((this.mainTable.getSelectedRow() + 1) % this.mainTable.getRowCount());
    }

    public void selectFirstEntry() {
        this.highlightEntry(0);
    }

    public void selectLastEntry() {
        this.highlightEntry(this.mainTable.getRowCount() - 1);
    }

    public void entryEditorClosing(EntryEditor editor) {
        Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        this.selectionListener.entryEditorClosing(editor);
    }

    public void ensureNotShowingBottomPanel(BibEntry entry) {
        if (this.mode == BasePanelMode.SHOWING_EDITOR && this.entryEditor.getEntry() == entry || this.mode == BasePanelMode.SHOWING_PREVIEW && this.selectionListener.getPreview().getEntry() == entry) {
            this.hideBottomComponent();
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            BibEntry currentEntry = this.entryEditor.getEntry();
            this.showAndEdit(currentEntry);
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.markBasedChangedInternal();
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.markBasedChangedInternal());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.info("Problem marking database as changed", e);
            }
        }
    }

    private void markBasedChangedInternal() {
        this.frame.setWindowTitle();
        this.frame.updateAllTabTitles();
        if (this.frame.getStatusLineText().startsWith(Localization.lang("Saved library", new String[0]))) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    private synchronized void markChangedOrUnChanged() {
        if (this.getUndoManager().hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.getBibDatabaseContext().getDatabaseFile().isPresent()) {
                this.frame.setTabTitle(this, this.getTabTitle(), this.getBibDatabaseContext().getDatabaseFile().get().getAbsolutePath());
            } else {
                this.frame.setTabTitle(this, GUIGlobals.UNTITLED_TITLE, null);
            }
        }
        this.frame.setWindowTitle();
    }

    public BibDatabase getDatabase() {
        return this.bibDatabaseContext.getDatabase();
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void changeTypeOfSelectedEntries(String newType) {
        List<BibEntry> bes = this.mainTable.getSelectedEntries();
        this.changeType(bes, newType);
    }

    private void changeType(List<BibEntry> entries, String newType) {
        int choice;
        if (entries == null || entries.isEmpty()) {
            LOGGER.error("At least one entry must be selected to be able to change the type.");
            return;
        }
        if (entries.size() > 1 && (choice = JOptionPane.showConfirmDialog(this, Localization.lang("Multiple entries selected. Do you want to change the type of all these to '%0'?", newType), Localization.lang("Change entry type", new String[0]), 0, 2)) == 1) {
            return;
        }
        NamedCompound compound = new NamedCompound(Localization.lang("Change entry type", new String[0]));
        for (BibEntry entry : entries) {
            compound.addEdit(new UndoableChangeType(entry, entry.getType(), newType));
            DefaultTaskExecutor.runInJavaFXThread(() -> entry.setType(newType));
        }
        this.output(this.formatOutputMessage(Localization.lang("Changed type to '%0' for", newType), entries.size()));
        compound.end();
        this.getUndoManager().addEdit(compound);
        this.markBaseChanged();
        this.updateEntryEditorIfShowing();
    }

    public boolean showDeleteConfirmationDialog(int numberOfEntries) {
        if (Globals.prefs.getBoolean("confirmDelete")) {
            String msg = Localization.lang("Really delete the selected entry?", new String[0]);
            String title = Localization.lang("Delete entry", new String[0]);
            if (numberOfEntries > 1) {
                msg = Localization.lang("Really delete the %0 selected entries?", Integer.toString(numberOfEntries));
                title = Localization.lang("Delete multiple entries", new String[0]);
            }
            CheckBoxMessage cb = new CheckBoxMessage(msg, Localization.lang("Disable this confirmation dialog", new String[0]), false);
            int answer = JOptionPane.showConfirmDialog(this.frame, cb, title, 0, 3);
            if (cb.isSelected()) {
                Globals.prefs.putBoolean("confirmDelete", false);
            }
            return answer == 0;
        }
        return true;
    }

    public void autoGenerateKeysBeforeSaving() {
        if (Globals.prefs.getBoolean("generateKeysBeforeSaving")) {
            NamedCompound ce = new NamedCompound(Localization.lang("Autogenerate BibTeX keys", new String[0]));
            BibtexKeyGenerator keyGenerator = new BibtexKeyGenerator(this.bibDatabaseContext, Globals.prefs.getBibtexKeyPatternPreferences());
            for (BibEntry bes : this.bibDatabaseContext.getDatabase().getEntries()) {
                Optional<String> oldKey = bes.getCiteKeyOptional();
                if (!StringUtil.isBlank(oldKey)) continue;
                Optional<FieldChange> change = keyGenerator.generateAndSetKey(bes);
                change.ifPresent(fieldChange -> ce.addEdit(new UndoableKeyChange((FieldChange)fieldChange)));
            }
            if (ce.hasEdits()) {
                ce.end();
                this.getUndoManager().addEdit(ce);
            }
        }
    }

    public void saveDividerLocation() {
        if (this.mode == BasePanelMode.SHOWING_PREVIEW) {
            int previewPanelHeight = this.splitPane.getHeight() - this.splitPane.getDividerLocation();
            PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences().getBuilder().withPreviewPanelHeight(previewPanelHeight).build();
            Globals.prefs.storePreviewPreferences(previewPreferences);
        } else if (this.mode == BasePanelMode.SHOWING_EDITOR) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void cleanUp() {
        FileUpdatePanel fup;
        this.changeMonitor.ifPresent(DatabaseChangeMonitor::unregister);
        if (this.sidePaneManager.hasComponent(FileUpdatePanel.class) && (fup = (FileUpdatePanel)this.sidePaneManager.getComponent(FileUpdatePanel.class)).getPanel() == this) {
            this.sidePaneManager.hideComponent(FileUpdatePanel.class);
        }
    }

    public List<BibEntry> getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public BibDatabaseContext getBibDatabaseContext() {
        return this.bibDatabaseContext;
    }

    public boolean isUpdatedExternally() {
        return this.changeMonitor.map(DatabaseChangeMonitor::hasBeenModifiedExternally).orElse(false);
    }

    public void markExternalChangesAsResolved() {
        this.changeMonitor.ifPresent(DatabaseChangeMonitor::markExternalChangesAsResolved);
    }

    public SidePaneManager getSidePaneManager() {
        return this.sidePaneManager;
    }

    public void setNonUndoableChange(boolean nonUndoableChange) {
        this.nonUndoableChange = nonUndoableChange;
    }

    public void setBaseChanged(boolean baseChanged) {
        this.baseChanged = baseChanged;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    private BibEntry getShowing() {
        return this.showing;
    }

    private void newEntryShowing(BibEntry entry) {
        if (this.backOrForwardInProgress) {
            this.showing = entry;
            this.backOrForwardInProgress = false;
            this.setBackAndForwardEnabledState();
            return;
        }
        this.nextEntries.clear();
        if (!Objects.equals(entry, this.showing)) {
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
                if (this.previousEntries.size() > 10) {
                    this.previousEntries.remove(0);
                }
            }
            this.showing = entry;
            this.setBackAndForwardEnabledState();
        }
    }

    private void back() {
        if (!this.previousEntries.isEmpty()) {
            BibEntry toShow = this.previousEntries.get(this.previousEntries.size() - 1);
            this.previousEntries.remove(this.previousEntries.size() - 1);
            if (this.showing != null) {
                this.nextEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    private void forward() {
        if (!this.nextEntries.isEmpty()) {
            BibEntry toShow = this.nextEntries.get(this.nextEntries.size() - 1);
            this.nextEntries.remove(this.nextEntries.size() - 1);
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    public void setBackAndForwardEnabledState() {
        this.frame.getBackAction().setEnabled(!this.previousEntries.isEmpty());
        this.frame.getForwardAction().setEnabled(!this.nextEntries.isEmpty());
    }

    private String formatOutputMessage(String start, int count) {
        return String.format("%s %d %s.", start, count, count > 1 ? Localization.lang("entries", new String[0]) : Localization.lang("entry", new String[0]));
    }

    private void setPreviewActiveBasePanels(boolean enabled) {
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            this.frame.getBasePanelAt(i).setPreviewActive(enabled);
        }
    }

    private void setPreviewActive(boolean enabled) {
        if (enabled) {
            this.showPreview();
        } else {
            this.preview.close();
        }
    }

    public CountingUndoManager getUndoManager() {
        return this.undoManager;
    }

    public MainTable getMainTable() {
        return this.mainTable;
    }

    public Optional<SearchQuery> getCurrentSearchQuery() {
        return this.currentSearchQuery;
    }

    public void setCurrentSearchQuery(SearchQuery currentSearchQuery) {
        this.currentSearchQuery = Optional.ofNullable(currentSearchQuery);
    }

    public CitationStyleCache getCitationStyleCache() {
        return this.citationStyleCache;
    }

    public PreviewPanel getPreviewPanel() {
        return this.preview;
    }

    public FileAnnotationCache getAnnotationCache() {
        return this.annotationCache;
    }

    public void resetChangeMonitor() {
        this.changeMonitor.ifPresent(DatabaseChangeMonitor::unregister);
        this.changeMonitor = Optional.of(new DatabaseChangeMonitor(this.bibDatabaseContext, Globals.getFileUpdateMonitor(), this));
    }

    public void updateTimeStamp() {
        this.changeMonitor.ifPresent(DatabaseChangeMonitor::markAsSaved);
    }

    public Path getTempFile() {
        return this.changeMonitor.map(DatabaseChangeMonitor::getTempFile).orElse(null);
    }

    private class SaveSelectedAction
    implements BaseAction {
        private final SavePreferences.DatabaseSaveType saveType;

        public SaveSelectedAction(SavePreferences.DatabaseSaveType saveType) {
            this.saveType = saveType;
        }

        @Override
        public void action() throws SaveException {
            FXDialogService ds = new FXDialogService();
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withDefaultExtension(StandardFileType.BIBTEX_DB).addExtensionFilter(String.format("%1s %2s", "BibTex", Localization.lang("Library", new String[0])), (FileType)StandardFileType.BIBTEX_DB).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            Optional chosenFile = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileSaveDialog(fileDialogConfiguration));
            if (chosenFile.isPresent()) {
                Path path = (Path)chosenFile.get();
                BasePanel.this.saveDatabase(path.toFile(), true, Globals.prefs.getDefaultEncoding(), this.saveType);
                BasePanel.this.frame.getFileHistory().newFile(path.toString());
                BasePanel.this.frame.output(Localization.lang("Saved selected to '%0'.", path.toString()));
            }
        }
    }

    private class PrintPreviewAction
    implements BaseAction {
        private PrintPreviewAction() {
        }

        @Override
        public void action() throws Exception {
            BasePanel.this.showPreview();
            BasePanel.this.preview.print();
        }
    }

    private class RedoAction
    implements BaseAction {
        private RedoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent focused = Globals.getFocusListener().getFocused();
                BasePanel.this.getUndoManager().redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(Localization.lang("Redo", new String[0]));
            }
            catch (CannotRedoException ex) {
                BasePanel.this.frame.output(Localization.lang("Nothing to redo", new String[0]) + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    private class OpenURLAction
    implements BaseAction {
        private OpenURLAction() {
        }

        @Override
        public void action() {
            List<BibEntry> bes = BasePanel.this.mainTable.getSelectedEntries();
            if (bes.size() == 1) {
                String field2 = "doi";
                Optional<String> link = bes.get(0).getField("doi");
                if (bes.get(0).hasField("url")) {
                    link = bes.get(0).getField("url");
                    field2 = "url";
                }
                if (link.isPresent()) {
                    try {
                        JabRefDesktop.openExternalViewer(BasePanel.this.bibDatabaseContext, link.get(), field2);
                        BasePanel.this.output(Localization.lang("External viewer called", new String[0]) + '.');
                    }
                    catch (IOException ex) {
                        BasePanel.this.output(Localization.lang("Error", new String[0]) + ": " + ex.getMessage());
                    }
                } else {
                    FileListEntry entry = null;
                    FileListTableModel tm = new FileListTableModel();
                    bes.get(0).getField("file").ifPresent(tm::setContent);
                    for (int i = 0; i < tm.getRowCount(); ++i) {
                        FileListEntry flEntry = tm.getEntry(i);
                        if (!"url".equalsIgnoreCase(flEntry.getType().get().getName()) && !"ps".equalsIgnoreCase(flEntry.getType().get().getName()) && !"pdf".equalsIgnoreCase(flEntry.getType().get().getName())) continue;
                        entry = flEntry;
                        break;
                    }
                    if (entry == null) {
                        BasePanel.this.output(Localization.lang("No URL defined", new String[0]) + '.');
                    } else {
                        try {
                            JabRefDesktop.openExternalFileAnyFormat(BasePanel.this.bibDatabaseContext, entry.getLink(), entry.getType());
                            BasePanel.this.output(Localization.lang("External viewer called", new String[0]) + '.');
                        }
                        catch (IOException e) {
                            BasePanel.this.output(Localization.lang("Could not open link", new String[0]));
                            LOGGER.info("Could not open link", e);
                        }
                    }
                }
            } else {
                BasePanel.this.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
            }
        }
    }

    private class UndoAction
    implements BaseAction {
        private UndoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent focused = Globals.getFocusListener().getFocused();
                if (focused != null && focused instanceof FieldEditor && focused.hasFocus()) {
                    FieldEditor fieldEditor = (FieldEditor)((Object)focused);
                    if (BasePanel.this.preambleEditor != null && fieldEditor.equals(BasePanel.this.preambleEditor.getFieldEditor())) {
                        BasePanel.this.preambleEditor.storeCurrentEdit();
                    }
                }
                BasePanel.this.getUndoManager().undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(Localization.lang("Undo", new String[0]));
            }
            catch (CannotUndoException ex) {
                LOGGER.warn("Nothing to undo", ex);
                BasePanel.this.frame.output(Localization.lang("Nothing to undo", new String[0]) + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    private class SearchListener {
        private SearchListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            BasePanel.this.frame.getGlobalSearchBar().setDontSelectSearchBar();
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }

        @Subscribe
        public void listen(EntryRemovedEvent removedEntryEvent) {
            BasePanel.this.frame.getGlobalSearchBar().performSearch();
        }
    }

    private class SearchAutoCompleteListener {
        private SearchAutoCompleteListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            BasePanel.this.searchAutoCompleter.indexEntry(addedEntryEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            BasePanel.this.searchAutoCompleter.indexEntry(entryChangedEvent.getBibEntry());
        }
    }

    private class EntryRemovedListener {
        private EntryRemovedListener() {
        }

        @Subscribe
        public void listen(EntryRemovedEvent entryRemovedEvent) {
            BibEntry previewEntry;
            if (BasePanel.this.mode == BasePanelMode.SHOWING_EDITOR && BasePanel.this.entryEditor.getEntry().equals(entryRemovedEvent.getBibEntry())) {
                BasePanel.this.entryEditor.close();
            }
            if ((previewEntry = BasePanel.this.selectionListener.getPreview().getEntry()) != null && previewEntry.equals(entryRemovedEvent.getBibEntry())) {
                BasePanel.this.preview.close();
            }
        }
    }

    private class GroupTreeListener {
        private GroupTreeListener() {
        }

        @Subscribe
        public void listen(EntryAddedEvent addedEntryEvent) {
            if (addedEntryEvent.getEntryEventSource() == EntryEventSource.UNDO) {
                return;
            }
            if (Globals.prefs.getBoolean("autoAssignGroup")) {
                List<BibEntry> entries = Collections.singletonList(addedEntryEvent.getBibEntry());
                Globals.stateManager.getSelectedGroup(BasePanel.this.bibDatabaseContext).forEach(selectedGroup -> selectedGroup.addEntriesToGroup(entries));
            }
        }
    }

    private static class SearchAndOpenFile {
        private final BibEntry entry;
        private final BasePanel basePanel;

        public SearchAndOpenFile(BibEntry entry, BasePanel basePanel) {
            this.entry = entry;
            this.basePanel = basePanel;
        }

        public void searchAndOpen() {
            if (!Globals.prefs.getBoolean("runAutomaticFileSearch")) {
                return;
            }
            Set<ExternalFileType> types = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
            List<Path> dirs = this.basePanel.getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences());
            List<String> extensions = types.stream().map(ExternalFileType::getExtension).collect(Collectors.toList());
            FileFinder fileFinder = FileFinders.constructFromConfiguration(Globals.prefs.getAutoLinkPreferences());
            try {
                List<Path> files = fileFinder.findAssociatedFiles(this.entry, dirs, extensions);
                if (!files.isEmpty()) {
                    Path file = files.get(0);
                    Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByFile(file);
                    if (type.isPresent()) {
                        JabRefDesktop.openExternalFileAnyFormat(file, this.basePanel.getBibDatabaseContext(), type);
                        this.basePanel.output(Localization.lang("External viewer called", new String[0]) + '.');
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Problems with finding/or opening files ", ex);
                this.basePanel.output(Localization.lang("Error", new String[0]) + ": " + ex.getMessage());
            }
        }
    }
}

