/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.VariableWrapper;
import de.undercouch.citeproc.VariableWrapperParams;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import de.undercouch.citeproc.helper.json.StringJsonBuilder;
import de.undercouch.citeproc.script.AbstractScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JREScriptRunner
extends AbstractScriptRunner {
    private final ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");

    @Override
    public String getName() {
        return this.engine.getFactory().getEngineName();
    }

    @Override
    public String getVersion() {
        return this.engine.getFactory().getEngineVersion();
    }

    @Override
    public void eval(Reader reader) throws ScriptRunnerException {
        try {
            this.engine.eval(reader);
        }
        catch (ScriptException e) {
            throw new ScriptRunnerException("Could not evaluate code", e);
        }
    }

    @Override
    public JsonBuilder createJsonBuilder() {
        return new StringJsonBuilder(this);
    }

    @Override
    public <T> T callMethod(String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        Invocable i = (Invocable)((Object)this.engine);
        try {
            return this.convert(i.invokeFunction(name, this.convertArguments(args)), resultType);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        catch (ScriptException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public void callMethod(String name, Object ... args) throws ScriptRunnerException {
        Invocable i = (Invocable)((Object)this.engine);
        try {
            i.invokeFunction(name, this.convertArguments(args));
        }
        catch (NoSuchMethodException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        catch (ScriptException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public <T> T callMethod(Object obj, String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        Invocable i = (Invocable)((Object)this.engine);
        try {
            return this.convert(i.invokeMethod(obj, name, this.convertArguments(args)), resultType);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        catch (ScriptException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public void callMethod(Object obj, String name, Object ... args) throws ScriptRunnerException {
        Invocable i = (Invocable)((Object)this.engine);
        try {
            i.invokeMethod(obj, name, this.convertArguments(args));
        }
        catch (NoSuchMethodException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        catch (ScriptException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public <T> T convert(Object r, Class<T> resultType) {
        if (List.class.isAssignableFrom(resultType) && r instanceof Map) {
            r = ((Map)((Object)r)).values();
        }
        return (T)r;
    }

    private Object[] convertArguments(Object[] args) throws ScriptException {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            result[i] = o == null ? null : (o instanceof JsonObject || o instanceof Collection || o.getClass().isArray() || o instanceof Map && o.getClass().getPackage().getName().startsWith("java.") ? this.engine.eval("(" + this.createJsonBuilder().toJson(o).toString() + ")") : (o instanceof VariableWrapper ? (o = new VariableWrapperWrapper((VariableWrapper)o)) : o));
        }
        return result;
    }

    public static class VariableWrapperWrapper {
        private final VariableWrapper wrapper;

        public VariableWrapperWrapper(VariableWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public String wrap(Map<String, Object> params, String prePunct, String str, String postPunct) {
            VariableWrapperParams p = VariableWrapperParams.fromJson(params);
            return this.wrapper.wrap(p, prePunct, str, postPunct);
        }
    }
}

