/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlyphsBuilder {
    private GlyphIcon glyphIcon;

    private GlyphsBuilder(Class<? extends GlyphIcon> clazz) {
        try {
            this.glyphIcon = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(GlyphsBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static GlyphsBuilder create(Class<? extends GlyphIcon> clazz) {
        return new GlyphsBuilder(clazz);
    }

    public GlyphsBuilder glyph(GlyphIcons glyph) {
        this.glyphIcon.setGlyphName(glyph.name());
        return this;
    }

    public GlyphsBuilder size(String size) {
        this.glyphIcon.setSize(size);
        return this;
    }

    public GlyphsBuilder style(String style) {
        this.glyphIcon.setGlyphStyle(style);
        return this;
    }

    public GlyphsBuilder styleClass(String styleClass) {
        this.glyphIcon.setStyleClass(styleClass);
        return this;
    }

    public GlyphIcon build() {
        return this.glyphIcon;
    }
}

