/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseCoordinator;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseDataFetcher;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseDataSender;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulsePingSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitData;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitDataBuilder;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataCollector;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataSender;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.DeviceInfo;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public enum QuickPulse implements Stoppable
{
    INSTANCE;

    private volatile boolean initialized = false;
    private Thread thread;
    private Thread senderThread;
    private DefaultQuickPulseCoordinator coordinator;
    private ApacheSender apacheSender;
    private QuickPulseDataSender quickPulseDataSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (!this.initialized) {
            QuickPulse quickPulse = INSTANCE;
            synchronized (quickPulse) {
                if (!this.initialized) {
                    this.initialized = true;
                    String quickPulseId = UUID.randomUUID().toString().replace("-", "");
                    this.apacheSender = ApacheSenderFactory.INSTANCE.create();
                    ArrayBlockingQueue<HttpPost> sendQueue = new ArrayBlockingQueue<HttpPost>(256, true);
                    this.quickPulseDataSender = new DefaultQuickPulseDataSender(this.apacheSender, sendQueue);
                    String instanceName = DeviceInfo.getHostName();
                    if (LocalStringsUtils.isNullOrEmpty(instanceName)) {
                        instanceName = "Unknown host";
                    }
                    String ikey = TelemetryConfiguration.getActive().getInstrumentationKey();
                    DefaultQuickPulsePingSender quickPulsePingSender = new DefaultQuickPulsePingSender(this.apacheSender, instanceName, quickPulseId);
                    DefaultQuickPulseDataFetcher quickPulseDataFetcher = new DefaultQuickPulseDataFetcher(sendQueue, ikey, instanceName, quickPulseId);
                    QuickPulseCoordinatorInitData coordinatorInitData = new QuickPulseCoordinatorInitDataBuilder().withPingSender(quickPulsePingSender).withDataFetcher(quickPulseDataFetcher).withDataSender(this.quickPulseDataSender).build();
                    this.coordinator = new DefaultQuickPulseCoordinator(coordinatorInitData);
                    this.senderThread = new Thread((Runnable)this.quickPulseDataSender, QuickPulseDataSender.class.getSimpleName());
                    this.senderThread.setDaemon(true);
                    this.senderThread.start();
                    this.thread = new Thread((Runnable)this.coordinator, DefaultQuickPulseCoordinator.class.getSimpleName());
                    this.thread.setDaemon(true);
                    this.thread.start();
                    SDKShutdownActivity.INSTANCE.register(this);
                    QuickPulseDataCollector.INSTANCE.enable(ikey);
                }
            }
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (!this.initialized) {
            return;
        }
        try {
            this.coordinator.stop();
            this.quickPulseDataSender.stop();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            try {
                InternalLogger.INSTANCE.error("Error while executing stop QuickPulse", new Object[0]);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        this.senderThread.interrupt();
        try {
            this.senderThread.join();
        }
        catch (InterruptedException e) {
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        this.initialized = false;
    }
}

