/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Record;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.PsuedoType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Records
extends SimpleProcProvider {
    public Records() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "record_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Record.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            this.writeComposite(buffer, type.getDelimeter(), (CompositeType)type, (Record)val, context);
        }

        void writeComposite(StringBuilder out, char delim, CompositeType type, Record val, Context context) throws IOException {
            out.append('(');
            Object[] vals = val.getAttributeValues();
            for (int c = 0; c < vals.length; ++c) {
                CompositeType.Attribute attr = type.getAttribute(c + 1);
                Type.Codec codec = attr.getType().getCodec(ResultField.Format.Text);
                StringBuilder attrOut = new StringBuilder();
                codec.getEncoder().encode(attr.getType(), attrOut, vals[c], context);
                String attrStr = attrOut.toString();
                if (TxtEncoder.needsQuotes(attrStr, delim)) {
                    attrStr = attrStr.replace("\\", "\\\\");
                    attrStr = attrStr.replace("\"", "\\\"");
                    out.append('\"').append(attrStr).append('\"');
                } else {
                    out.append(attrStr);
                }
                if (c >= vals.length - 1) continue;
                out.append(delim);
            }
            out.append(')');
        }

        private static boolean needsQuotes(String elemStr, char delim) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != delim && ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public Class<?> getOutputType() {
            return Record.class;
        }

        @Override
        public Record decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            int length = buffer.length();
            Object[] instance = null;
            if (length != 0) {
                ArrayList<Object> fields = new ArrayList<Object>();
                this.readComposite(buffer, 0, type.getDelimeter(), (CompositeType)type, context, fields);
                instance = fields.toArray();
            }
            return new Record(type.getName(), ((CompositeType)type).getAttributesTypes(), instance);
        }

        int readComposite(CharSequence data, int start, char delim, CompositeType type, Context context, List<Object> fields) throws IOException {
            int c;
            if (data.equals("()")) {
                return start + 1;
            }
            StringBuilder elementTxt = null;
            int len = data.length();
            block5: for (c = start + 1; c < len; ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '(': {
                        ArrayList<Object> subElements = new ArrayList<Object>();
                        c = this.readComposite(data, c, delim, type, context, subElements);
                        fields.add(subElements.toArray());
                        continue block5;
                    }
                    case ')': {
                        if (elementTxt == null) break block5;
                        fields.add(this.decode(elementTxt.toString(), type.getAttribute(fields.size() + 1).getType(), context));
                        break block5;
                    }
                    case '\"': {
                        elementTxt = elementTxt != null ? elementTxt : new StringBuilder();
                        c = this.readString(data, c, elementTxt);
                        continue block5;
                    }
                    default: {
                        if (Character.isWhitespace(ch)) {
                            c = this.skipWhitespace(data, c);
                            continue block5;
                        }
                        if (ch == delim) {
                            if (elementTxt != null) {
                                fields.add(this.decode(elementTxt.toString(), type.getAttribute(fields.size() + 1).getType(), context));
                            }
                            elementTxt = null;
                            continue block5;
                        }
                        elementTxt = elementTxt != null ? elementTxt : new StringBuilder();
                        elementTxt.append(ch);
                    }
                }
            }
            return c;
        }

        int skipWhitespace(CharSequence data, int start) {
            int c;
            int len = data.length();
            for (c = start; c < len && Character.isWhitespace(data.charAt(c)); ++c) {
            }
            return c;
        }

        int readString(CharSequence data, int start, StringBuilder string) {
            int c;
            int len = data.length();
            block4: for (c = start + 1; c < len; ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '\"': {
                        if (c >= data.length() - 1 || data.charAt(c + 1) != '\"') break block4;
                        ++c;
                        string.append('\"');
                        continue block4;
                    }
                    case '\\': {
                        if (++c < data.length()) {
                            ch = data.charAt(c);
                        }
                    }
                    default: {
                        string.append(ch);
                    }
                }
            }
            return c;
        }

        Object decode(String elementTxt, Type type, Context context) throws IOException {
            if (elementTxt.equals("NULL")) {
                return null;
            }
            return type.getCodec(ResultField.Format.Text).getDecoder().decode(type, null, null, elementTxt, context);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Record.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int writeStart = buffer.writerIndex();
                Record record = (Record)val;
                Object[] attributeVals = record.getAttributeValues();
                CompositeType compType = (CompositeType)type;
                List<CompositeType.Attribute> attributes = compType.getAttributes();
                buffer.writeInt(attributes.size());
                for (CompositeType.Attribute attribute : attributes) {
                    Type attributeType = attribute.getType();
                    buffer.writeInt(attributeType.getId());
                    Object attributeVal = attributeVals[attribute.getNumber() - 1];
                    attributeType.getBinaryCodec().getEncoder().encode(attributeType, buffer, attributeVal, context);
                }
                buffer.setInt(writeStart - 4, buffer.writerIndex() - writeStart);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public Class<?> getOutputType() {
            return Record.class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            CompositeType compType;
            if (type instanceof CompositeType) {
                compType = (CompositeType)type;
            } else if (type instanceof PsuedoType && type.getName().equals("record")) {
                compType = null;
            } else {
                throw new IOException("Unsupported type for Record decode");
            }
            ArrayList<Type> attributeTypes = new ArrayList<Type>();
            Record record = null;
            int length = buffer.readInt();
            if (length != -1) {
                long readStart = buffer.readerIndex();
                int itemCount = buffer.readInt();
                Object[] attributeVals = new Object[itemCount];
                for (int c = 0; c < itemCount; ++c) {
                    Object attributeVal;
                    Type attributeType = context.getRegistry().loadType(buffer.readInt());
                    attributeTypes.add(attributeType);
                    if (compType != null) {
                        CompositeType.Attribute attribute = compType.getAttribute(c + 1);
                        if (attributeType.getId() != attribute.getType().getId()) {
                            context.refreshType(attributeType.getId());
                        }
                    }
                    attributeVals[c] = attributeVal = attributeType.getBinaryCodec().getDecoder().decode(attributeType, null, null, buffer, context);
                }
                if ((long)length != (long)buffer.readerIndex() - readStart) {
                    throw new IllegalStateException();
                }
                record = new Record(type.getName(), attributeTypes.toArray(new Type[attributeTypes.size()]), attributeVals);
            }
            return record;
        }
    }
}

