/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.views;

import com.airhacks.afterburner.injection.Injector;
import com.airhacks.afterburner.injection.PresenterFactory;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public abstract class FXMLView
extends StackPane {
    public static final String DEFAULT_ENDING = "View";
    protected ObjectProperty<Object> presenterProperty;
    protected FXMLLoader fxmlLoader;
    protected String bundleName;
    protected ResourceBundle bundle;
    protected final Function<String, Object> injectionContext;
    protected URL resource;
    protected static Executor FX_PLATFORM_EXECUTOR = Platform::runLater;
    protected static final ExecutorService PARENT_CREATION_POOL = FXMLView.getExecutorService();

    public FXMLView() {
        this(f -> null);
    }

    public FXMLView(Function<String, Object> injectionContext) {
        this.injectionContext = injectionContext;
        this.init(this.getFXMLName());
    }

    private void init(String conventionalName) {
        this.presenterProperty = new SimpleObjectProperty();
        this.resource = ((Object)((Object)this)).getClass().getResource(conventionalName);
        this.bundleName = this.getBundleName();
        this.bundle = FXMLView.getResourceBundle(this.bundleName);
    }

    FXMLLoader loadSynchronously(URL resource, ResourceBundle bundle, String conventionalName) throws IllegalStateException {
        FXMLLoader loader = new FXMLLoader(resource, bundle);
        PresenterFactory factory = this.discover();
        Callback controllerFactory = p -> factory.instantiatePresenter(p, this.injectionContext);
        loader.setControllerFactory(controllerFactory);
        try {
            loader.load();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load " + conventionalName, ex);
        }
        return loader;
    }

    PresenterFactory discover() {
        Iterable<PresenterFactory> discoveredFactories = PresenterFactory.discover();
        List<PresenterFactory> factories = StreamSupport.stream(discoveredFactories.spliterator(), false).collect(Collectors.toList());
        if (factories.isEmpty()) {
            return Injector::instantiatePresenter;
        }
        if (factories.size() == 1) {
            return (PresenterFactory)factories.get(0);
        }
        factories.forEach(System.err::println);
        throw new IllegalStateException("More than one PresenterFactories discovered");
    }

    void initializeFXMLLoader() {
        if (this.fxmlLoader == null) {
            this.fxmlLoader = this.loadSynchronously(this.resource, this.bundle, this.bundleName);
            this.presenterProperty.set(this.fxmlLoader.getController());
        }
    }

    public Parent getView() {
        this.initializeFXMLLoader();
        Parent parent = (Parent)this.fxmlLoader.getRoot();
        this.addCSSIfAvailable(parent);
        return parent;
    }

    public void getView(Consumer<Parent> consumer) {
        Supplier<Parent> supplier = this::getView;
        ((CompletableFuture)CompletableFuture.supplyAsync(supplier, FX_PLATFORM_EXECUTOR).thenAccept((Consumer)consumer)).exceptionally(this::exceptionReporter);
    }

    public void getViewAsync(Consumer<Parent> consumer) {
        Supplier<Parent> supplier = this::getView;
        ((CompletableFuture)CompletableFuture.supplyAsync(supplier, PARENT_CREATION_POOL).thenAcceptAsync((Consumer)consumer, FX_PLATFORM_EXECUTOR)).exceptionally(this::exceptionReporter);
    }

    public Node getViewWithoutRootContainer() {
        ObservableList children = this.getView().getChildrenUnmodifiable();
        if (children.isEmpty()) {
            return null;
        }
        return (Node)children.listIterator().next();
    }

    void addCSSIfAvailable(Parent parent) {
        URL uri = ((Object)((Object)this)).getClass().getResource(this.getStyleSheetName());
        if (uri == null) {
            return;
        }
        String uriToCss = uri.toExternalForm();
        parent.getStylesheets().add((Object)uriToCss);
    }

    String getStyleSheetName() {
        return this.getResourceCamelOrLowerCase(false, ".css");
    }

    final String getFXMLName() {
        return this.getResourceCamelOrLowerCase(true, ".fxml");
    }

    String getResourceCamelOrLowerCase(boolean mandatory, String ending) {
        String name = this.getConventionalName(true, ending);
        URL found = ((Object)((Object)this)).getClass().getResource(name);
        if (found != null) {
            return name;
        }
        System.err.println("File: " + name + " not found, attempting with camel case");
        name = this.getConventionalName(false, ending);
        found = ((Object)((Object)this)).getClass().getResource(name);
        if (mandatory && found == null) {
            String message = "Cannot load file " + name;
            System.err.println(message);
            System.err.println("Stopping initialization phase...");
            throw new IllegalStateException(message);
        }
        return name;
    }

    public Object getPresenter() {
        this.initializeFXMLLoader();
        return this.presenterProperty.get();
    }

    public void getPresenter(Consumer<Object> presenterConsumer) {
        this.presenterProperty.addListener((o, oldValue, newValue) -> presenterConsumer.accept(newValue));
    }

    protected String getConventionalName(boolean lowercase, String ending) {
        return this.getConventionalName(lowercase) + ending;
    }

    protected String getConventionalName(boolean lowercase) {
        String clazzWithEnding = ((Object)((Object)this)).getClass().getSimpleName();
        String clazz = FXMLView.stripEnding(clazzWithEnding);
        if (lowercase) {
            clazz = clazz.toLowerCase();
        }
        return clazz;
    }

    String getBundleName() {
        String conventionalName = this.getConventionalName(true);
        return ((Object)((Object)this)).getClass().getPackage().getName() + "." + conventionalName;
    }

    static String stripEnding(String clazz) {
        if (!clazz.endsWith(DEFAULT_ENDING)) {
            return clazz;
        }
        int viewIndex = clazz.lastIndexOf(DEFAULT_ENDING);
        return clazz.substring(0, viewIndex);
    }

    public static ResourceBundle getResourceBundle(String name) {
        try {
            return ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            String name = thread.getName();
            thread.setName("afterburner.fx-" + name);
            thread.setDaemon(true);
            return thread;
        });
    }

    public Void exceptionReporter(Throwable t) {
        System.err.println(t);
        return null;
    }
}

